<?php

namespace Meetanshi\OrderUpload\Model\Checkout;

use Magento\Checkout\Model\Session;
use Magento\Checkout\Model\GuestPaymentInformationManagement;
use Magento\Quote\Api\Data\PaymentInterface;
use Magento\Quote\Api\Data\AddressInterface;

class GuestPaymentInformationManagementPlugin
{
    protected $checkoutSession;

    public function __construct(
        Session $checkoutSession
    )
    {
        $this->checkoutSession = $checkoutSession;
    }

    public function aroundSavePaymentInformationAndPlaceOrder(
        GuestPaymentInformationManagement $subject,
        \Closure $proceed,
        $cartId,
        $email,
        PaymentInterface $paymentMethod,
        AddressInterface $billingAddress = null
    )
    {
        $comment = NULL;
        $request = file_get_contents('php://input');
        $data = json_decode($request, true);
        if (isset ($data['paymentMethod']['additional_data']['comments'])) {
            $orderComments = $data['paymentMethod']['additional_data']['comments'];
            if ($orderComments) {
                $comment = $orderComments;
            }
        }
        $quote = $this->checkoutSession->getQuote();
        $quote->setOrderComment($comment);
        $quote->save();

        $orderId = $proceed($cartId, $email, $paymentMethod, $billingAddress);
        return $orderId;
    }
}
