<?php

namespace Meetanshi\OrderUpload\Helper;

use Magento\Framework\App\Area;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Meetanshi\OrderUpload\Helper\Template\TransportBuilder;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Email extends AbstractHelper
{
    const XML_PATH_EMAIL_TEMPLATE_FIELD = 'orderupload/email/email_template';
    const XML_PATH_ADD_ATTACHMENT = 'orderupload/email/attachment';

    protected $scopeConfig;
    protected $storeManager;
    protected $inlineTranslation;
    protected $transportBuilder;
    protected $tempId;

    public function __construct(Context $context, StoreManagerInterface $storeManager, StateInterface $inlineTranslation, TransportBuilder $transportBuilder)
    {
        $this->scopeConfig = $context;
        parent::__construct($context);
        $this->storeManager = $storeManager;
        $this->inlineTranslation = $inlineTranslation;
        $this->transportBuilder = $transportBuilder;
    }

    public function customMailSendMethod($emailTemplateVariables, $senderInfo, $receiverInfo, $file)
    {
        try {
            $this->tempId = $this->getTemplateId(self::XML_PATH_EMAIL_TEMPLATE_FIELD);
            $this->inlineTranslation->suspend();
            $this->generateTemplate($emailTemplateVariables, $senderInfo, $receiverInfo, $file);
            $transport = $this->transportBuilder->getTransport();
            $transport->sendMessage();
            $this->inlineTranslation->resume();
        } catch (\Exception $e) {
            print_r($e->getMessage());
        }
    }

    public function getTemplateId($xmlPath)
    {
        return $this->getConfigValue($xmlPath, $this->getStore()->getStoreId());
    }

    protected function getConfigValue($path, $storeId)
    {
        return $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getStore()
    {
        return $this->storeManager->getStore();
    }

    public function generateTemplate($emailTemplateVariables, $senderInfo, $receiverInfo, $file)
    {
        $emailTemplate = $this->transportBuilder->setTemplateIdentifier($this->tempId)->setTemplateOptions(['area' => Area::AREA_FRONTEND, 'store' => $this->storeManager->getStore()->getId(),])->setTemplateVars($emailTemplateVariables)->setFrom($senderInfo)->addTo($receiverInfo['email'], $receiverInfo['name']);
        if ($this->getAddAttachment() == 1) {
            foreach ($file as $fileData) {
                $fileData = explode("=>", $fileData);
                $emailTemplate->addAttachment($fileData[1], \Zend_Mime::TYPE_OCTETSTREAM, \Zend_Mime::DISPOSITION_ATTACHMENT, \Zend_Mime::ENCODING_BASE64, $fileData[0]);
            }
        }
        return $this;
    }

    public function getAddAttachment($store = null)
    {
        $storeConfig = $this->scopeConfig->getValue(self::XML_PATH_ADD_ATTACHMENT, ScopeInterface::SCOPE_STORE, $store);
        return $storeConfig;
    }
}
