<?php

namespace Meetanshi\OrderUpload\Controller\Upload;

use Meetanshi\OrderUpload\Model\Upload as UploadModel;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Sales\Model\OrderFactory;
use Magento\Customer\Model\CustomerFactory;
use Meetanshi\OrderUpload\Helper\Data;
use Meetanshi\OrderUpload\Helper\Email;
use Meetanshi\OrderUpload\Model\OrderUploadFactory;

class Save extends Action
{
    protected $uploadModel;
    protected $orderUploadFactory;
    protected $customerFactory;
    protected $helper;
    protected $emailHelper;
    protected $orderFactory;

    public function __construct(Context $context, UploadModel $uploadModel, OrderFactory $orderFactory, CustomerFactory $customerFactory, Data $helper, Email $emailHelper, OrderUploadFactory $orderUploadFactory)
    {
        $this->uploadModel = $uploadModel;
        $this->orderFactory = $orderFactory;
        $this->customerFactory = $customerFactory;
        $this->helper = $helper;
        $this->emailHelper = $emailHelper;
        $this->orderUploadFactory = $orderUploadFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $post = $this->getRequest()->getPostValue();
        if ($post) {
            try {
                $postData = $post['orderupload'];
                $time = time();
                $orderId = $this->getRequest()->getPostValue('order_id');
                $customerId = $this->getRequest()->getPostValue('customer_id');
                $sendFile = [];
                $pubMediaUrl = $this->helper->pubMediaPath();
                $sendMailToAdmin = $this->helper->sendMailToAdmin();
                foreach ($postData as $data) {
                    $model = $this->orderUploadFactory->create();
                    if (isset($data['remove'])) {
                        if (isset($data['file_exist']) && !empty($data['file_exist'])) {
                            $model->load($data['file_exist']);
                            $model->delete();
                        }
                    } else {
                        if (isset($data['new_file']) && !empty($data['new_file'])) {
                            $model->setCreatedAt($time);
                            $model->setUpdatedAt($time);
                        }
                        if (isset($data['file_exist']) && !empty($data['file_exist'])) {
                            $model->load($data['file_exist']);
                            $model->setUpdatedAt($time);
                        }
                        $model->setComment($data['comment']);
                        $model->setVisibleCustomerAccount(1);
                        $model->setOrderId($orderId);
                        $model->setCustomerId($customerId);
                        $model->setFileName($data['file_name']);
                        $model->setFilePath($data['file_path']);
                        $model->save();

                        $file = file_get_contents($pubMediaUrl . $data['file_path']);
                        $sendFile[] = $data['file_name'] . "=>" . $file;
                    }
                }

                if ($this->helper->isSendEmail() && $sendMailToAdmin) {
                    $order = $this->orderFactory->create()->load($orderId);
                    $customer = $this->customerFactory->create()->load($customerId);
                    $customerName = $customer->getName();
                    $customerEmail = $customer->getEmail();
                    $adminEmail = $this->helper->getAdminEmail();
                    $adminName = $this->helper->getAdminName();

                    $sender = ['name' => $customerName, 'email' => $customerEmail,];
                    $receiver = ['name' => $adminName, 'email' => $adminEmail,];

                    $emailTempVariables = [];
                    $emailTempVariables['order_id'] = $order->getIncrementId();
                    $emailTempVariables['update'] = "customer";
                    $emailTempVariables['name'] = $customerName;
                    $emailTempVariables['email'] = $customerEmail;
                    $this->emailHelper->customMailSendMethod($emailTempVariables, $sender, $receiver, $sendFile);
                }

                $this->messageManager->addSuccessMessage(__('Attachments details have been saved successfully.'));
                $resultRedirect->setUrl($this->_redirect->getRefererUrl());
                return $resultRedirect;
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                $resultRedirect->setUrl($this->_redirect->getRefererUrl());
                return $resultRedirect;
            }
        } else {
            $this->messageManager->addErrorMessage(__('Please try again later.'));
            $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }
    }
}
