<?php

namespace Meetanshi\OrderUpload\Controller\Upload;

use Meetanshi\OrderUpload\Model\OrderUpload\FileUploaderFactory;
use Magento\Checkout\Model\Cart;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Filesystem;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\ResultFactory;
use Magento\Quote\Api\CartRepositoryInterface;

class Remove extends Action
{
    private $resultJsonFactory;
    private $filesystem;
    private $fileUploaderFactory;
    private $cart;
    private $quoteRepository;

    public function __construct(Context $context, Cart $cart, CartRepositoryInterface $quoteRepository, JsonFactory $resultJsonFactory, Filesystem $filesystem, FileUploaderFactory $fileUploaderFactory)
    {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->filesystem = $filesystem;
        $this->fileUploaderFactory = $fileUploaderFactory;
        $this->cart = $cart;
        $this->quoteRepository = $quoteRepository;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        try {
            $cartQuote = $this->cart->getQuote();
            $cartQuote->setFileData('');
            $this->quoteRepository->save($cartQuote);
        } catch (\Exception $e) {
            $this->messageManager->addSuccessMessage(__('Attachments details have been saved successfully.'));
            $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }
        $this->messageManager->addSuccessMessage(__('Attachments details have been saved successfully.'));
        $resultRedirect->setUrl($this->_redirect->getRefererUrl());
        return $resultRedirect;
    }
}
