<?php

namespace Meetanshi\OrderUpload\Controller\Upload;

use Meetanshi\OrderUpload\Model\OrderUpload\FileUploaderFactory;
use Meetanshi\OrderUpload\Model\OrderUpload;
use Magento\Checkout\Model\Cart;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Quote\Api\CartRepositoryInterface;

class Checkout extends Action
{
    private $resultJsonFactory;
    private $filesystem;
    private $fileUploaderFactory;
    private $cart;
    private $quoteRepository;

    public function __construct(Context $context, Cart $cart, CartRepositoryInterface $quoteRepository, JsonFactory $resultJsonFactory, Filesystem $filesystem, FileUploaderFactory $fileUploaderFactory)
    {
        $this->resultJsonFactory = $resultJsonFactory;
        $this->filesystem = $filesystem;
        $this->fileUploaderFactory = $fileUploaderFactory;
        $this->cart = $cart;
        $this->quoteRepository = $quoteRepository;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $fileUploader = $this->fileUploaderFactory->create(['fileId' => 'file[0]']);
            $mediaDirectory = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA);
            $result = $fileUploader->save($mediaDirectory->getAbsolutePath(OrderUpload::ORDERUPLOAD_TMP_PATH));
            $cartQuote = $this->cart->getQuote();
            $cartQuote->setFileData(json_encode($result));
            $this->quoteRepository->save($cartQuote);
        } catch (\Exception $e) {
            $result = ['error' => $e->getMessage(), 'errorcode' => $e->getCode()];
        }

        $resultJson = $this->resultJsonFactory->create();
        return $resultJson->setData($result);
    }
}
