<?php

namespace Meetanshi\OrderUpload\Block\Sales\Order\View;

use Meetanshi\OrderUpload\Helper\Data;
use Meetanshi\OrderUpload\Model\OrderUploadFactory;
use Magento\Customer\Helper\Session\CurrentCustomer;
use Magento\Customer\Model\Session;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\ProductAlert\Model\StockFactory;
use Magento\Framework\UrlInterface;

class Fileuploads extends Template
{
    protected $customerSession;
    protected $urlBuilder;
    protected $currentCustomer;

    public function __construct(Context $context, Session $customerSession, Data $helper, StockFactory $stockFactory, Registry $registry, CurrentCustomer $currentCustomer, OrderUploadFactory $orderUploadFactory, array $data = [])
    {
        $this->currentCustomer = $currentCustomer;
        $this->stockFactory = $stockFactory;
        $this->helper = $helper;
        $this->storeManager = $context->getStoreManager();
        $this->registry = $registry;
        $this->urlBuilder = $context->getUrlBuilder();
        $this->customerSession = $customerSession;
        $this->orderUploadFactory = $orderUploadFactory;
        $this->filesystem = $context->getFilesystem();
        parent::__construct($context, $data);
        $collection = $this->stockFactory->create()->getCollection();
        $collection->addFieldToFilter('customer_id', $this->currentCustomer->getCustomerId());
        $this->setCollection($collection);
    }

    public function isCustomerAllowed()
    {
        return $this->helper->isCustomerCanAdd();
    }

    public function isValid()
    {
        return $this->helper->isValidCustomerGroup();
    }

    public function getBaseUrl()
    {
        return $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_LINK);
    }

    public function allowedDocSizes()
    {
        return $this->helper->getFileExtensions();
    }

    public function fileSize()
    {
        return $this->helper->getMaxFileSize();
    }

    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    public function getFileUploadUrl()
    {
        return $this->getUrl('orderupload/upload/upload');
    }

    public function getOrderId()
    {
        return $this->getOrder()->getId();
    }

    public function getOrder()
    {
        return $this->registry->registry('current_order');
    }

    public function getCustomerId()
    {
        return $this->getOrder()->getCustomerId();
    }

    public function pubMediaPath()
    {
        return $this->helper->pubMediaPath();
    }

    public function getAttachedFiles()
    {
        $orderId = $this->getOrder()->getId();
        $collection = $this->orderUploadFactory->create()->getCollection();
        $collection->addFieldToFilter('order_id', $orderId);
        return $collection->getData();
    }

    public function canDelete()
    {
        return $this->helper->canDelete();
    }

    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if ($this->getCollection()) :
            $pager = $this->getLayout()->createBlock('Magento\Theme\Block\Html\Pager', 'meetanshi.orderupload.record.pager')->setCollection($this->getCollection());
            $this->setChild('pager', $pager);
        endif;
        return $this;
    }
}
