<?php

namespace Meetanshi\OrderUpload\Block;

use Meetanshi\OrderUpload\Model\OrderUploadFactory;
use Magento\Framework\Registry;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\ProductAlert\Model\StockFactory;
use Meetanshi\OrderUpload\Helper\Data;
use Magento\Sales\Model\OrderFactory;
use Magento\Customer\Model\Session;

class OrderUploads extends Template
{
    protected $storeManager;
    protected $urlBuilder;
    protected $orderFactory;
    protected $session;

    public function __construct(Context $context, StockFactory $stockFactory, Registry $registry, OrderUploadFactory $orderUploadFactory, Session $session, Data $helper, OrderFactory $orderFactory, array $data = [])
    {
        $this->helper = $helper;
        $this->isScopePrivate = true;
        $this->stockFactory = $stockFactory;
        $this->storeManager = $context->getStoreManager();
        $this->registry = $registry;
        $this->urlBuilder = $context->getUrlBuilder();
        $this->orderUploadFactory = $orderUploadFactory;
        $this->filesystem = $context->getFilesystem();
        $this->orderFactory = $orderFactory;
        $this->session = $session;
        parent::__construct($context, $data);
        $custSession = $this->session;
        $custId = $custSession->getId();
        $collection = $this->orderUploadFactory->create()->getCollection();
        $collection->addFieldToFilter('customer_id', $custId);
        $this->setCollection($collection);
    }

    public function isValid()
    {
        return $this->helper->isValidCustomerGroup();
    }

    public function getOrderId($orderId)
    {
        $order = $this->orderFactory->create()->load($orderId);
        return $order->getIncrementId();
    }

    public function pubMediaPath()
    {
        return $this->helper->pubMediaPath();
    }

    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    public function getBaseUrl()
    {
        return $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_LINK);
    }

    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if ($this->getCollection()) :
            $pager = $this->getLayout()->createBlock('Magento\Theme\Block\Html\Pager', 'meetanshi.orderupload.record.pager')->setCollection($this->getCollection());
            $this->setChild('pager', $pager);
        endif;
        return $this;
    }
}
