<?php

namespace Meetanshi\OrderUpload\Block\Adminhtml\Order\View\Tab;

use Meetanshi\OrderUpload\Helper\Data;
use Meetanshi\OrderUpload\Model\OrderUploadFactory;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Registry;
use Magento\Sales\Helper\Admin;

class OrderUpload extends Template implements TabInterface
{
    protected $_template = 'order/view/tab/uploads.phtml';

    public function __construct(Context $context, Registry $registry, Data $helper, Admin $adminHelper, OrderUploadFactory $orderUploadFactory, array $data = [])
    {
        $this->registry = $registry;
        $this->helper = $helper;
        $this->filesystem = $context->getViewFileSystem();
        $this->orderUploadFactory = $orderUploadFactory;
        $this->adminHelper = $adminHelper;
        parent::__construct($context, $data);
    }

    public function getSource()
    {
        return $this->getOrder();
    }

    public function getTabLabel()
    {
        return __('Order Attachments');
    }

    public function getTabTitle()
    {
        return __('Order Attachments');
    }

    public function getFileUploadUrl()
    {
        return $this->getUrl('orderupload/orderupload/upload');
    }

    public function getOrderId()
    {
        return $this->getOrder()->getId();
    }

    public function canShowTab()
    {
        return true;
    }

    public function isHidden()
    {
        return false;
    }

    public function getCustomerId()
    {
        return $this->getOrder()->getCustomerId();
    }

    public function pubMediaPath()
    {
        return $this->helper->pubMediaPath();
    }

    public function getOrder()
    {
        return $this->registry->registry('current_order');
    }

    public function allowedDocSizes()
    {
        return $this->helper->getFileExtensions();
    }

    public function fileSize()
    {
        return $this->helper->getMaxFileSize();
    }

    public function canDelete()
    {
        return $this->helper->canDelete();
    }

    public function getAttachedFiles()
    {
        $orderId = $this->getOrder()->getId();
        $collection = $this->orderUploadFactory->create()->getCollection();
        $collection->addFieldToFilter('order_id', $orderId);
        return $collection->getData();
    }
}
