<?php
/**
 * Created by PhpStorm.
 * User: marcoprontera
 * Date: 06/07/20
 * Time: 14.37
 */
namespace Magestore\Bannerslider\Setup;


use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
class UpgradeSchema implements  UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup,
                            ModuleContextInterface $context){
        $setup->startSetup();
        if (version_compare($context->getVersion(), '1.7.2') < 0) {

            // Get module table
            $tableName = $setup->getTable('magestore_bannerslider_slider');

            // Check if the table already exists
            if ($setup->getConnection()->isTableExists($tableName) == true) {
                // Declare data
                $columns = [
                    'use_yt_video' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                        'nullable' => false,
                        'default' => '0',
                        'comment' => 'Enable youtube video'
                    ],
                    'yt_desktop_code' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'value' => null,
                        'nullable' => true,
                        'comment' => 'Youtube desktop code'
                    ],
                    'yt_mobile_code' => [
                        'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                        'value' => null,
                        'nullable' => true,
                        'comment' => 'Youtube mobile code'
                    ]
                ];

                $connection = $setup->getConnection();
                foreach ($columns as $name => $definition) {
                    $connection->addColumn($tableName, $name, $definition);
                }

            }
        }

        $setup->endSetup();
    }
}