<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Observer;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\Event\ObserverInterface;
use Mageplaza\GiftCard\Helper\Checkout as GiftCardCheckoutHelper;

/**
 * Class PaypalPrepareItems
 * @package Mageplaza\GiftCard\Observer
 */
class PaypalPrepareItems implements ObserverInterface
{
    /**
     * @var CheckoutSession
     */
    protected $checkoutSession;

    /**
     * PaypalPrepareItems constructor.
     *
     * @param CheckoutSession $checkoutSession
     */
    public function __construct(CheckoutSession $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Add reward amount to payment discount total
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /** @var \Magento\Payment\Model\Cart $cart */
        $cart = $observer->getEvent()->getCart();

        $quote = $this->checkoutSession->getQuote();

        /** Discount from Gift Card code*/
        $giftcard = GiftCardCheckoutHelper::jsonDecode($quote->getGiftCards());

        /** Discount from Gift Card Credit*/
        $gcCredit = $quote->getGcCredit();

        $discount = 0;
        if ($giftcard) {
            foreach ($giftcard as $k => $v) {
                $discount += $v;
            }
        }

        if ($discount > 0.0001) {
            $cart->addCustomItem('Gift Card', 1, -1.00 * $discount);
        }

        if ($gcCredit > 0.0001) {
            $cart->addCustomItem('Gift Card Credit', 1, -1.00 * $gcCredit);
        }
    }
}
