<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Mageplaza\GiftCard\Cron\Notification;
use Mageplaza\GiftCard\Cron\Process;

/**
 * Class Check
 * @package Magento\Customer\Controller\Ajax
 */
class Cron extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $pageFactory;

    /**
     * @var \Mageplaza\GiftCard\Cron\Notification
     */
    protected $notification;

    /**
     * @var \Mageplaza\GiftCard\Cron\Process
     */
    protected $process;

    /**
     * Cron constructor.
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Mageplaza\GiftCard\Cron\Notification $cronNotification
     * @param \Mageplaza\GiftCard\Cron\Process $cronProcess
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Notification $cronNotification,
        Process $cronProcess
    )
    {
        $this->pageFactory  = $resultPageFactory;
        $this->notification = $cronNotification;
        $this->process      = $cronProcess;
        
        parent::__construct($context);
    }

    /**
     * test cron
     */
    public function execute()
    {
        $this->notification->execute();
        $this->process->execute();
    }
}
