<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Controller\Adminhtml\Pool;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Mageplaza\GiftCard\Controller\Adminhtml\Pool;
use Mageplaza\GiftCard\Model\PoolFactory;

/**
 * Class ExportCouponsCsv
 * @package Mageplaza\GiftCard\Controller\Adminhtml\Template
 */
class ExportCouponsCsv extends Pool
{
    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry;

    /**
     * @var \Magento\Framework\App\Response\Http\FileFactory
     */
    protected $_fileFactory;

    /**
     * Constructor.
     *
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Mageplaza\GiftCard\Model\PoolFactory $poolFactory
     * @param \Magento\Framework\App\Response\Http\FileFactory $fileFactory
     */
    public function __construct(
        Registry $registry,
        Context $context,
        PageFactory $resultPageFactory,
        PoolFactory $poolFactory,
        FileFactory $fileFactory
    )
    {
        $this->_coreRegistry = $registry;
        $this->_fileFactory  = $fileFactory;

        parent::__construct($context, $resultPageFactory, $poolFactory);
    }

    /**
     * Export coupon codes as CSV file
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|null
     * @throws \Exception
     */
    public function execute()
    {
        $pool = $this->_initObject();

        if ($pool->getId()) {
            $fileName = "pool_{$pool->getId()}.csv";
            $this->_coreRegistry->register('current_pool', $pool);

            $content = $this->_view->getLayout()
                ->createBlock('Mageplaza\GiftCard\Block\Adminhtml\Pool\Edit\Tab\Generate\Grid')
                ->getCsvFile();

            return $this->_fileFactory->create($fileName, $content, DirectoryList::VAR_DIR);
        }

        return null;
    }
}
