<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Controller\Adminhtml\Customer;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Mageplaza\GiftCard\Helper\Data as DataHelper;
use Mageplaza\GiftCard\Model\Transaction\Action as TransactionAction;
use Mageplaza\GiftCard\Model\TransactionFactory;

/**
 * Class Change
 * @package Mageplaza\GiftCard\Controller\Adminhtml\Customer
 */
class Change extends Action
{
    /**
     * @type \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $_resultJsonFactory;

    /**
     * @type DataHelper
     */
    protected $_dataHelper;

    /**
     * @type \Mageplaza\GiftCard\Model\TransactionFactory
     */
    protected $_transactionFactory;

    /**
     * Change constructor.
     *
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Mageplaza\GiftCard\Helper\Data $dataHelper
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \Mageplaza\GiftCard\Model\TransactionFactory $transactionFactory
     */
    public function __construct(
        Action\Context $context,
        DataHelper $dataHelper,
        JsonFactory $resultJsonFactory,
        TransactionFactory $transactionFactory
    )
    {
        $this->_dataHelper         = $dataHelper;
        $this->_resultJsonFactory  = $resultJsonFactory;
        $this->_transactionFactory = $transactionFactory;

        parent::__construct($context);
    }

    /**
     * Execute - Change Customer balance amount
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $result  = ['error' => true];
        $request = $this->getRequest();
        if ($request->getParam('isAjax')) {
            $customerId = $request->getParam('customer_id');
            $customer   = $this->_dataHelper->getCustomer($customerId);
            $amount     = $request->getParam('amount');
            $currency   = $customer->getStore()->getBaseCurrency();

            /** @var \Mageplaza\GiftCard\Model\Transaction $transaction */
            $transaction = $this->_transactionFactory->create();

            try {
                $transaction->createTransaction(
                    TransactionAction::ACTION_ADMIN,
                    $amount,
                    $customer,
                    ['auth' => $this->_auth->getUser()->getName()]
                );

                $balance = $this->_dataHelper->getCustomerBalance($customerId, false);
                $result  = [
                    'error'            => false,
                    'balance'          => $balance,
                    'balanceFormatted' => $this->_dataHelper->formatPrice($balance, true, null, $currency)
                ];
            } catch (\Exception $e) {
                $result['message'] = $e->getMessage();
            }
        } else {
            $result['message'] = __('An error occur. Please try again later.');
        }

        return $this->_resultJsonFactory->create()->setData($result);
    }
}
