<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Block;

use Magento\Catalog\Block\Product\Context;
use Magento\Customer\Model\Session;
use Magento\Framework\View\Element\Template;
use Mageplaza\GiftCard\Helper\Data as DataHelper;
use Mageplaza\GiftCard\Model\CreditFactory;
use Mageplaza\GiftCard\Model\GiftCard;
use Mageplaza\GiftCard\Model\Transaction;

/**
 * Class Dashboard
 * @package Mageplaza\GiftCard\Block
 */
class Dashboard extends Template
{
    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $customerSession;

    /**
     * @var \Mageplaza\GiftCard\Model\CreditFactory
     */
    protected $_creditFactory;

    /**
     * @var \Mageplaza\GiftCard\Helper\Customer
     */
    protected $giftCardHelper;

    /**
     * @var \Mageplaza\GiftCard\Model\Transaction
     */
    protected $_transaction;

    /**
     * @var \Mageplaza\GiftCard\Model\GiftCard
     */
    protected $_giftCard;

    /**
     * Dashboard constructor.
     *
     * @param \Magento\Catalog\Block\Product\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Mageplaza\GiftCard\Model\CreditFactory $creditFactory
     * @param \Mageplaza\GiftCard\Helper\Data $giftCardHelper
     * @param \Mageplaza\GiftCard\Model\Transaction $transaction
     * @param \Mageplaza\GiftCard\Model\GiftCard $giftCard
     * @param array $data
     */
    public function __construct(
        Context $context,
        Session $customerSession,
        CreditFactory $creditFactory,
        DataHelper $giftCardHelper,
        Transaction $transaction,
        GiftCard $giftCard,
        array $data = []
    )
    {
        $this->customerSession = $customerSession;
        $this->_creditFactory  = $creditFactory;
        $this->giftCardHelper  = $giftCardHelper;
        $this->_transaction    = $transaction;
        $this->_giftCard       = $giftCard;

        parent::__construct($context, $data);
    }

    /**
     * Returns popup config
     *
     * @return array
     * @throws \Exception
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getConfig()
    {
        $customer = $this->customerSession->getCustomer();
        if (!$customer || !$customer->getId()) {
            return [];
        }

        $emailEnable       = $this->giftCardHelper->getEmailConfig('enable');
        $creditEmailEnable = $this->giftCardHelper->getEmailConfig('credit/enable');

        $creditAccount = $this->_creditFactory->create()
            ->load($customer->getId(), 'customer_id');
        $code          = $this->getRequest()->getParam('code');

        return [
            'baseUrl'        => $this->getBaseUrl(),
            'customerEmail'  => $customer->getEmail(),
            'code'           => $code,
            'balance'        => $this->giftCardHelper->getCustomerBalance($customer, true, true),
            'transactions'   => $this->_transaction->getTransactionsForCustomer($customer->getId()),
            'giftCardLists'  => $this->_giftCard->getGiftCardListForCustomer($customer->getId()),
            'isEnableCredit' => (bool)$this->giftCardHelper->getGeneralConfig('enable_credit'),
            'notification'   => [
                'enable'               => $emailEnable,
                'creditEnable'         => $creditEmailEnable,
                'creditNotification'   => is_null($creditAccount->getCreditNotification()) ? true : (boolean)$creditAccount->getCreditNotification(),
                'giftcardNotification' => is_null($creditAccount->getGiftcardNotification()) ? true : (boolean)$creditAccount->getGiftcardNotification()
            ]
        ];
    }
}
