<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_GiftCard
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GiftCard\Block\Adminhtml\Customer\Edit\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Customer\Controller\RegistryConstants;
use Magento\Framework\Registry;
use Mageplaza\GiftCard\Helper\Data as DataHelper;
use Mageplaza\GiftCard\Model\ResourceModel\Transaction\CollectionFactory;
use Mageplaza\GiftCard\Model\Transaction\Action;

/**
 * Class Transaction
 * @package Mageplaza\GiftCard\Block\Adminhtml\Customer\Edit\Tab
 */
class Transaction extends Extended
{
    /**
     * @type \Mageplaza\GiftCard\Model\ResourceModel\Transaction\CollectionFactory
     */
    protected $_collectionFactory;

    /**
     * @var \Mageplaza\GiftCard\Model\Transaction\Action
     */
    protected $_action;

    /**
     * @type \Mageplaza\GiftCard\Helper\Data
     */
    protected $_helper;

    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry;

    /**
     * Transaction constructor.
     *
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Backend\Helper\Data $backendHelper
     * @param \Mageplaza\GiftCard\Model\ResourceModel\Transaction\CollectionFactory $collectionFactory
     * @param \Mageplaza\GiftCard\Model\Transaction\Action $action
     * @param \Magento\Framework\Registry $registry
     * @param \Mageplaza\GiftCard\Helper\Data $dataHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        CollectionFactory $collectionFactory,
        Action $action,
        Registry $registry,
        DataHelper $dataHelper,
        array $data = []
    )
    {
        $this->_collectionFactory = $collectionFactory;
        $this->_action            = $action;
        $this->_coreRegistry      = $registry;
        $this->_helper            = $dataHelper;

        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * Initialize grid
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setId('transaction_grid');
        $this->setDefaultSort('transaction_id', 'asc');
        $this->setUseAjax(true);
    }

    /**
     * Get Customer Id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->_coreRegistry->registry(RegistryConstants::CURRENT_CUSTOMER_ID);
    }

    /**
     * @inheritdoc
     */
    protected function _prepareCollection()
    {
        $collection = $this->_collectionFactory->create();
        $collection->getSelect()
            ->join(
                ['cr' => $collection->getTable('mageplaza_giftcard_credit')],
                "main_table.credit_id = cr.credit_id AND cr.customer_id = " . $this->getCustomerId(),
                ['customer_id']
            );

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    /**
     * @return $this
     * @throws \Exception
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function _prepareColumns()
    {
        $this->addColumn('transaction_id', [
            'header'           => __('#'),
            'index'            => 'transaction_id',
            'header_css_class' => 'col-id',
            'column_css_class' => 'col-id'
        ]);

        $this->addColumn('created_at', [
            'header'           => __('Date'),
            'type'             => 'datetime',
            'index'            => 'created_at',
            'header_css_class' => 'col-date',
            'column_css_class' => 'col-date'
        ]);

        $this->addColumn('action', [
            'header'  => __('Action'),
            'index'   => 'action',
            'type'    => 'options',
            'options' => $this->_action->getOptionArray()
        ]);

        $customer = $this->_helper->getCustomer($this->getCustomerId());

        $this->addColumn('balance', [
            'header'        => __('Balance'),
            'filter'        => false,
            'align'         => 'right',
            'index'         => 'balance',
            'type'          => 'price',
            'currency_code' => $customer->getStore()->getBaseCurrencyCode()
        ]);

        $this->addColumn('amount', [
            'header'        => __('Amount Change'),
            'filter'        => false,
            'align'         => 'right',
            'index'         => 'amount',
            'type'          => 'price',
            'currency_code' => $customer->getStore()->getBaseCurrencyCode()
        ]);

        $this->addColumn('detail', [
            'header'   => __('Detail'),
            'filter'   => false,
            'sortable' => false,
            'renderer' => '\Mageplaza\GiftCard\Block\Adminhtml\Customer\Edit\Tab\Transaction\DetailRenderer',
        ]);

        return parent::_prepareColumns();
    }

    /**
     * {@inheritdoc}
     */
    public function getGridUrl()
    {
        return $this->getUrl('mpgiftcard/customer/grid', ['_current' => true]);
    }
}
