<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\Theme\Ui\Component\Listing\Column;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Store\Model\ScopeInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class EditAction
 */
class EditAction extends Column
{
    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * Constructor
     *
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = [],
        array $data = []
    ) {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                if (isset($item['entity_id'])) {
                    $editUrlPath = $this->getData('config/editUrlPath') ?: '#';
                    if (isset($item['store_id'])) {
                        $scope = ScopeInterface::SCOPE_STORES;
                        $scopeId = $item['store_id'];
                    } elseif (isset($item['store_website_id'])) {
                        $scope = ScopeInterface::SCOPE_WEBSITES;
                        $scopeId = $item['store_website_id'];
                    } else {
                        $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT;
                        $scopeId = null;
                    }
                    $item[$this->getData('name')] = [
                        'edit' => [
                            'href' => $this->urlBuilder->getUrl(
                                $editUrlPath,
                                [
                                    'scope' => $scope,
                                    'scope_id' => $scopeId,
                                ]
                            ),
                            'label' => __('Edit'),
                            '__disableTmpl' => true,
                        ]
                    ];
                }
            }
        }

        return $dataSource;
    }
}
