<?php
namespace Magebees\Promotionsnotification\Block\Adminhtml\Promotionsnotification\Edit\Tab;

class Product extends \Magento\Backend\Block\Widget\Form\Generic
{

    const DISPLAY_ALL = 'promotionsnotification_all';
    const DISPLAY_SELECTED = 'promotionsnotification_select';

    /**
     * @var \Magebees\Promotionsnotification\Model\Product
     */
    protected $_notificationproduct;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magebees\Promotionsnotification\Model\Product $notificationproduct,
        array $data = []
    ) {
        $this->_notificationproduct = $notificationproduct;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    protected function _prepareForm()
    {
        $id = $this->getRequest()->getParam('id');
        $product_val = $this->_notificationproduct->getCollection()
            ->addFieldToFilter('notification_id', ['eq' => $id])
            ->addFieldToFilter('product_sku', ['eq' => self::DISPLAY_ALL])
            ->getFirstItem();

        $displayProduct = self::DISPLAY_SELECTED;
        if(!empty($product_val->getProductSku())) {
            $displayProduct = self::DISPLAY_ALL;
        }

        $toOptionArray = [
            ['value' => self::DISPLAY_ALL, 'label' => __('Display on All Product Pages')],
            ['value' => self::DISPLAY_SELECTED, 'label' => __('Select products to display')]
        ];

        $form = $this->_formFactory->create();
        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('Products')]);
        $group_name = $fieldset->addField(
            'product_ids',
            'select',
            [
                'name' => 'product_ids',
                'label' => __('Visible In'),
                'title' => __('Visible In'),
                'required' => false,
                'values' => $toOptionArray,
                'disabled' => false,
                'value'         => $displayProduct,
            ]
        );

        $this->setForm($form);
        return parent::_prepareForm();
    }

    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
