<?php
/**
 * CacheWarmer
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace LizardMedia\VarnishWarmer\Cron;

use Magento\Framework\App\Config\ScopeConfigInterface;

class CacheWarmer
{

    const XML_PATH_CRON_ENABLED = 'lm_varnish/cron/enabled';

    /**
     * @var \LizardMedia\VarnishWarmer\Helper\CacheCleaner
     */
    protected $cacheCleaner;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    public function __construct(
        \LizardMedia\VarnishWarmer\Helper\CacheCleaner $cacheCleaner,
        \Psr\Log\LoggerInterface $logger,
        ScopeConfigInterface $scopeConfig
    )
    {
        $this->cacheCleaner = $cacheCleaner;
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
    }

    public function execute()
    {
        if(!$this->getCronIsEnabled()) {
            return;
        }

        try {
            $this->cacheCleaner->generateAll();
        } catch (Exception $e) {
            $this->logger->info(__METHOD__ . ': ' . $e->getMessage());
        }
    }

    private function getCronIsEnabled()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_CRON_ENABLED);
    }
}
