<?php

namespace LizardMedia\VarnishWarmer\Model\UrlProvider;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\App\ResourceConnectionFactory;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Cms\Model\ResourceModel\Page\CollectionFactory as CmsPageCollectionFactory;

/**
 * Class CmsPageUrlProvider
 * @package LizardMedia\VarnishWarmer\Model\UrlProvider
 */
class CmsPageUrlProvider
{

    /**
     * @var CmsPageCollectionFactory
     */
    protected $cmsPagesCollectionFactory;

    /**
     * @var ResourceConnectionFactory
     */
    protected $resourceConnectionFactory;

    /**
     * CmsPageUrlProvider constructor.
     * @param CmsPageCollectionFactory $cmsPagesCollectionFactory
     * @param ResourceConnectionFactory $resourceConnectionFactory
     */
    public function __construct(
        CmsPageCollectionFactory $cmsPagesCollectionFactory,
        ResourceConnectionFactory $resourceConnectionFactory
    ) {
        $this->cmsPagesCollectionFactory = $cmsPagesCollectionFactory;
        $this->resourceConnectionFactory = $resourceConnectionFactory;
    }

    /**
     * @return array
     */
    public function getCmsPageUrls(): array
    {
        /** @var ResourceConnection $connection */
        $connection = $this->resourceConnectionFactory->create();
        /** @var AdapterInterface $conn */
        $conn = $connection->getConnection();

        $cmsPagesIds = $this->getAvailableCmsPagesIds();
        $select = $conn
            ->select()
            ->from(
                [
                    'u' => $connection->getTableName('url_rewrite')
                ],
                ['request_path', 'store_id']
            )->where(
                'u.entity_type=?',
                'cms-page'
            )->where(
                'u.entity_id IN (' . implode(',', $cmsPagesIds) . ')'
            )->where(
                'u.redirect_type != 301'
            );
        return $conn->fetchAll($select);
    }


    /**
     * @return array
     */
    protected function getAvailableCmsPagesIds(): array
    {
        /** @var \Magento\Cms\Model\ResourceModel\Page\Collection $cmsPagesCollection */
        $cmsPagesCollection = $this->cmsPagesCollectionFactory->create();
        $cmsPagesCollection->addFieldToFilter(
            'is_active',
            1
        );
        return $cmsPagesCollection->getAllIds();
    }

}
