define([
        'jquery',
        'stockists_search'
    ],
    function ($, country_list) {
        return {
            search: function (map, config, address) {

                if (address[0]) {
                    if (config.viewAll == 0) {
                        for (var i = 0; i < markers.length; i++) {
                            markers[i].setMap(null);
                        }
                        markers = new Array();
                        // cancellare dalla mappa
                        // li ricalcolo
                        var url = window.location.protocol + "//" + window.location.hostname + "/stockists";
                        url = (url.substr(-1) != '/' ? url + '/' : url) + 'ajax/stores';
                        $.ajax({
                            dataType: 'json',
                            url: url,
                            data: {
                                lat: address[0].geometry.location.lat(),
                                lng: address[0].geometry.location.lng(),
                            }
                        }).done(function (response) {
                            // li reinserisco
                            insertMarkers(response);
                            initializeSearch();
                        });
                    } else {
                        initializeSearch();
                    }

                    function bindInfoWindow(marker, map, infowindow, data) {
                        google.maps.event.addListener(marker, 'click', function () {
                            var contentString = '<div class="stockists-window" data-latitude="' + marker.getPosition().lat() + '" data-longitude="' + marker.getPosition().lng() + '"><p class="stockists-title">' + data.name + '</p>'
                            if (data.external_link) {
                                var protocol_link = external_link.indexOf("http") > -1 ? data.external_link : "http://" + data.external_link;
                                contentString += '<p class="stockists-telephone"><a href="' + data.protocol_link + '" target="_blank">' + data.external_link + '</a></p>'
                            } else if (data.link) {
                                contentString += '<p class="stockists-telephone"><a href="/' + config.moduleUrl + '/' + data.link + '" target="_blank">Detail page</a></p>'
                            }
                            if (data.phone) {
                                contentString += '<p class="stockists-telephone">' + data.phone + '</p>';
                            }
                            if (data.telephone) {
                                contentString += '<p class="stockists-telephone">' + data.telephone + '</p>';
                            }
                            if (data.email) {
                                contentString += '<p class="stockists-address"><a href="mailto:' + data.email + '" target="_blank">' + data.email + '</a></p>';
                            }
                            if (data.address) {
                                contentString += '<p class="stockists-telephone">' + data.address + '</p>'
                            }
                            if (data.city) {
                                contentString += '<p class="stockists-telephone">' + data.city + '</p>'
                            }
                            if (data.postcode) {
                                contentString += '<p class="stockists-web">' + data.postcode + '</p>';
                            }

                            contentString += '<p class="ask-for-directions get-directions" data-directions="DRIVING"><a href="http://maps.google.com/maps?saddr=&daddr=' + marker.getPosition().lat() + ',' + marker.getPosition().lng() + '" target="_blank">' + $t("Get Directions") + '</a></p>';

                            //Working Hours
                            if (data.wo_general_indication || data.wo_monday || data.wo_tuesday || data.wo_wednesday || data.wo_thursday || data.wo_friday || data.wo_saturday || data.wo_sunday) {
                                contentString += '<p class="stockists-wo-title"><strong>' + $t("Working Hours") + ':</strong></p>';
                            }
                            if (data.wo_general_indication) {
                                contentString += '<p class="stockists-wo-general">' + data.wo_general_indication + '</p>';
                            }
                            if (data.wo_monday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-monday"><strong>' + $t("Monday") + ': </strong>' + data.wo_monday + '</p>';
                            }
                            if (data.wo_tuesday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-tuesday"><strong>' + $t("Tuesday") + ': </strong>' + data.wo_tuesday + '</p>';
                            }
                            if (data.wo_wednesday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-wednesday"><strong>' + $t("Wednesday") + ': </strong>' + data.wo_wednesday + '</p>';
                            }
                            if (data.wo_thursday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-thursday"><strong>' + $t("Thursday") + ': </strong>' + data.wo_thursday + '</p>';
                            }
                            if (data.wo_friday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-friday"><strong>' + $t("Friday") + ': </strong>' + data.wo_friday + '</p>';
                            }
                            if (data.wo_saturday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-saturday"><strong>' + $t("Saturday") + ': </strong>' + data.wo_saturday + '</p>';
                            }
                            if (data.wo_sunday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-sunday"><strong>' + $t("Sunday") + ': </strong>' + data.wo_sunday + '</p>';
                            }

                            contentString += '</div>';
                            map.setCenter(marker.getPosition());
                            infowindow.setContent(contentString);
                            infowindow.open(map, marker);
                        });
                    }

                    function insertMarkers(response) {

                        var image = {
                            url: config.map_pin
                        };
                        var infowindow = new google.maps.InfoWindow({
                            content: ""
                        });

                        var length = response.length

                        for (var i = 0; i < length; i++) {
                            var data = response[i];
                            var latLng = new google.maps.LatLng(data.latitude, data.longitude);
                            var record_id = "" + data.latitude + data.longitude;
                            var marker = new google.maps.Marker({
                                record_id: record_id,
                                global_name: data.name,
                                global_address: data.address,
                                global_city: data.city,
                                global_postcode: data.postcode,
                                global_country: data.country,
                                position: latLng,
                                map: map,
                                icon: image,
                                title: data.name
                            });
                            markers.push(marker);

                            bindInfoWindow(marker, map, infowindow, data);
                        }
                    }

                    function initializeSearch() {
                        $(".results-store").empty();
                        $(".results-store").append("<span class='results-word'><span class='italic'>" + address[0].formatted_address + ":</span></span><br />");

                        if (typeof window.search_markers === "undefined") {
                            window.search_markers = [];
                        }

                        map.setZoom(config.zoom);
                        map.setCenter(address[0].geometry.location);
                        var marker = new google.maps.Marker({
                            map: map,
                            position: address[0].geometry.location
                        });
                        // Remove previous marker
                        for (var i = 0; i < window.search_markers.length; i++) {
                            window.search_markers[i].setMap(null);
                        }
                        window.search_markers.push(marker);
                        if (window.circle) {
                            // If circle already exists on map, clear it
                            window.circle.setMap(null);
                        }
                        window.circle = new google.maps.Circle({
                            map: map,
                            radius: config.radius,    // value from admin settings
                            fillColor: config.fillColor,
                            fillOpacity: config.fillOpacity,
                            strokeColor: config.strokeColor,
                            strokeOpacity: config.strokeOpacity,
                            strokeWeight: config.strokeWeight
                        });
                        window.circle.bindTo('center', marker, 'position');

                        for (i = 0; i < markers.length; i++) {
                            var distance = google.maps.geometry.spherical.computeDistanceBetween(marker.position, markers[i].position);
                            if ((distance / 1000) < config.radius) {
                                if (config.unit == "default") {
                                    var store_distance = parseFloat(distance * 0.001).toFixed(2);
                                    var unitOfLength = "km";
                                } else if (config.unit == "miles") {
                                    var store_distance = parseFloat(distance * 0.000621371192).toFixed(2);
                                    var unitOfLength = "miles";
                                }
                                var contentToAppend = "<div class='results-content' data-miles='" + store_distance + "' data-marker='" + markers[i].record_id + "'><p class='results-title'>" + markers[i].global_name + "</p>";
                                if (markers[i].global_address) {
                                    contentToAppend += "<p class='results-address'>" + markers[i].global_address + "</p>";
                                }
                                if (markers[i].global_city) {
                                    contentToAppend += "<p class='data-phone'>" + markers[i].global_city + " " + markers[i].global_postcode + "</p>";
                                }
                                contentToAppend += "<p class='data-miles'>" + store_distance + " " + unitOfLength + "</p></div>";
                                $(".results-store").append(contentToAppend);
                            }
                        }
                        if(markers.length == 0) {
                            $(".results-store").append('<p class="mt-2">' + $.mage.__('No store found in the required area') + '</p>');
                        }
                        var $wrapper = $('.results-store');

                        //sort the result by distance
                        $wrapper.find('.results-content').sort(function (a, b) {
                            return +a.dataset.miles - +b.dataset.miles;
                        }).appendTo($wrapper);
                    }
                }
            }
        }
    }
);
