define([
        'jquery',
        'limesharp_stockists',
        'stockists_mapstyles',
        'stockists_search',
        'stockists_geolocation',
        'mage/translate'
    ],
    function ($, config, mapstyles, search_widget, currentLocation, $t) {
        return function (config) {
            $(document).ready(function () {
                $.getScript("https://maps.googleapis.com/maps/api/js?v=3&sensor=false&key=" + config.apiKey + "&libraries=geometry,places", function () {
                    getStores();
                });

                var map;
                markers = [];

                $("body").on("click", ".results-content", function () {
                    $(".results-content").not($(this)).removeClass("active");
                    $(this).addClass("active");
                });

                // full width template
                if (config.template == "full_width_sidebar" || config.template == "full_width_top") {
                    $("body").addClass("full-width");
                }

                // get the stores from admin stockists/ajax/stores
                function getStores() {
                    var url = window.location.protocol + "//" + window.location.hostname + "/stockists";
                    url = (url.substr(-1) != '/' ? url + '/' : url) + 'ajax/stores';
                    $.ajax({
                        dataType: 'json',
                        url: url,
                        data: {
                            lat: config.latitude,
                            lng: config.longitude
                        }
                    }).done(function (response) {
                        initialize(response);
                    });
                }

                function initialize(response) {
                    var mapElement = document.getElementById('map-canvas');
                    var loadedMapStyles = mapstyles[config.map_styles];
                    var mapOptions = {
                        zoom: config.zoom,
                        scrollwheel: false,
                        center: {lat: config.latitude, lng: config.longitude},
                        styles: loadedMapStyles
                    };

                    map = new google.maps.Map(mapElement, mapOptions);
                    var directionsService = new google.maps.DirectionsService();
                    var directionsDisplay = new google.maps.DirectionsRenderer();
                    directionsDisplay.setMap(map);

                    var searchBoxOptions = false; //TODO
                    searchBox = new google.maps.places.SearchBox(document.getElementById('pac-input'), searchBoxOptions);

                    $("#stockists-submit").on("click", function (e) {
                        google.maps.event.trigger(searchBox, 'place_changed');
                    });

                    $('#stockist-search-term').keypress(function (e) {
                        if (e.which == 13) { //Enter key pressed
                            if (searchBox.getPlaces() != undefined) {
                                google.maps.event.trigger(searchBox, 'place_changed');
                            }
                            return false;
                        }
                    });

                    searchBox.addListener('places_changed', function () {
                        var places = searchBox.getPlaces();
                        if ((places == null) || (places.length == 0)) {
                            var message = Translator.translate('Cannot get place geometry location');
                            self.showError(message);
                            console.log(message);
                            return;
                        }
                        search_widget.search(map, config, places);
                    });


                    getGeoLocation(map);
                    $(document).on("click", ".submit-location", function () {
                        getGeoLocation(map);
                    })

                    insertMarkers(response);

                    // attach click events for directions
                    if (navigator.geolocation) {
                        $(document).on("click", ".get-directions", function () {
                            var storeDirections = {
                                latitude: $(".stockists-window").attr("data-latitude"),
                                longitude: $(".stockists-window").attr("data-longitude")
                            };
                            var userTravelMode = $(this).attr("data-directions");
                            getGeoLocation(map, storeDirections, userTravelMode, directionsService, directionsDisplay);
                        })
                    }
                }

                function bindInfoWindow(marker, map, infowindow, data) {
                    google.maps.event.addListener(marker, 'click', function () {
                        var contentString = '<div class="stockists-window" data-latitude="' + marker.getPosition().lat() + '" data-longitude="' + marker.getPosition().lng() + '"><p class="stockists-title">' + data.name + '</p>'
                        if (data.external_link) {
                            var protocol_link = external_link.indexOf("http") > -1 ? data.external_link : "http://" + data.external_link;
                            contentString += '<p class="stockists-telephone"><a href="' + data.protocol_link + '" target="_blank">' + data.external_link + '</a></p>'
                        } else if (data.link) {
                            contentString += '<p class="stockists-telephone"><a href="/' + config.moduleUrl + '/' + data.link + '" target="_blank">Detail page</a></p>'
                        }
                        if (data.phone) {
                            contentString += '<p class="stockists-telephone">' + data.phone + '</p>';
                        }
                        if (data.telephone) {
                            contentString += '<p class="stockists-telephone">' + data.telephone + '</p>';
                        }
                        if (data.email) {
                            contentString += '<p class="stockists-address"><a href="mailto:' + data.email + '" target="_blank">' + data.email + '</a></p>';
                        }
                        if (data.address) {
                            contentString += '<p class="stockists-telephone">' + data.address + '</p>'
                        }
                        if (data.city) {
                            contentString += '<p class="stockists-telephone">' + data.city + '</p>'
                        }
                        if (data.postcode) {
                            contentString += '<p class="stockists-web">' + data.postcode + '</p>';
                        }

                        contentString += '<p class="ask-for-directions get-directions" data-directions="DRIVING"><a href="http://maps.google.com/maps?saddr=&daddr=' + marker.getPosition().lat() + ',' + marker.getPosition().lng() + '" target="_blank">' + $t("Get Directions") + '</a></p>';

                        //Working Hours
                        if (data.wo_general_indication || data.wo_monday || data.wo_tuesday || data.wo_wednesday || data.wo_thursday || data.wo_friday || data.wo_saturday || data.wo_sunday) {
                            contentString += '<p class="stockists-wo-title"><strong>' + $t("Working Hours") + ':</strong></p>';
                        }
                        if (data.wo_general_indication) {
                            contentString += '<p class="stockists-wo-general">' + data.wo_general_indication + '</p>';
                        }
                        if (data.wo_monday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-monday"><strong>' + $t("Monday") + ': </strong>' + data.wo_monday + '</p>';
                        }
                        if (data.wo_tuesday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-tuesday"><strong>' + $t("Tuesday") + ': </strong>' + data.wo_tuesday + '</p>';
                        }
                        if (data.wo_wednesday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-wednesday"><strong>' + $t("Wednesday") + ': </strong>' + data.wo_wednesday + '</p>';
                        }
                        if (data.wo_thursday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-thursday"><strong>' + $t("Thursday") + ': </strong>' + data.wo_thursday + '</p>';
                        }
                        if (data.wo_friday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-friday"><strong>' + $t("Friday") + ': </strong>' + data.wo_friday + '</p>';
                        }
                        if (data.wo_saturday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-saturday"><strong>' + $t("Saturday") + ': </strong>' + data.wo_saturday + '</p>';
                        }
                        if (data.wo_sunday) {
                            contentString += '<p class="stockists-wo-day stockists-wo-sunday"><strong>' + $t("Sunday") + ': </strong>' + data.wo_sunday + '</p>';
                        }

                        contentString += '</div>';
                        map.setCenter(marker.getPosition());
                        infowindow.setContent(contentString);
                        infowindow.open(map, marker);
                    });
                }

                function insertMarkers(response) {

                    var image = {
                        url: config.map_pin
                    };
                    var infowindow = new google.maps.InfoWindow({
                        content: ""
                    });

                    var length = response.length

                    for (var i = 0; i < length; i++) {
                        var data = response[i];
                        var latLng = new google.maps.LatLng(data.latitude, data.longitude);
                        var record_id = "" + data.latitude + data.longitude;
                        var marker = new google.maps.Marker({
                            record_id: record_id,
                            global_name: data.name,
                            global_address: data.address,
                            global_city: data.city,
                            global_postcode: data.postcode,
                            global_country: data.country,
                            position: latLng,
                            map: map,
                            icon: image,
                            title: data.name
                        });
                        markers.push(marker);

                        bindInfoWindow(marker, map, infowindow, data);
                    }
                }

                //gets geolocation, if storeDirections is set then it is interpreted as a way to getDirection
                function getGeoLocation(map, storeDirections, userTravelMode, directionsService, directionsDisplay) {
                    var geoOptions = function () {
                        return {
                            maximumAge: 5 * 60 * 1000,
                            timeout: 10 * 1000
                        }
                    };

                    var geoSuccess = function (position) {
                        if (config.viewAll == 0) {
                            // vuoto i markers
                            for (var i = 0; i < markers.length; i++) {
                                markers[i].setMap(null);
                            }
                            markers = new Array();
                            // cancellare dalla mappa
                            // li ricalcolo
                            var url = window.location.protocol + "//" + window.location.hostname + "/stockists";
                            url = (url.substr(-1) != '/' ? url + '/' : url) + 'ajax/stores';
                            $.ajax({
                                dataType: 'json',
                                url: url,
                                data: {
                                    lat: position.coords.latitude,
                                    lng: position.coords.longitude,
                                }
                            }).done(function (response) {
                                // li reinserisco
                                insertMarkers(response);
                                if (typeof storeDirections === 'undefined') {
                                    centerMap(position.coords, map, markers);
                                } else {
                                    var directionElement = document.getElementById('directions-panel');
                                    if (typeof(directionElement) != 'undefined' && directionElement != null) {
                                        //If exist is enabled
                                        getDirections(map, storeDirections, position.coords, userTravelMode, directionsService, directionsDisplay);
                                    }
                                }
                            });
                        } else {
                            if (typeof storeDirections === 'undefined') {
                                centerMap(position.coords, map, markers);
                            } else {
                                var directionElement = document.getElementById('directions-panel');
                                if (typeof(directionElement) != 'undefined' && directionElement != null) {
                                    //If exist is enabled
                                    getDirections(map, storeDirections, position.coords, userTravelMode, directionsService, directionsDisplay);
                                }
                            }
                        }

                        // if no params then just center it, otherwise call directions
                    };
                    var geoError = function (position) {
                        return;
                    };

                    navigator.geolocation.getCurrentPosition(geoSuccess, geoError, geoOptions);
                }

                $("body").on("click", ".results-content", function () {
                    var id = $(this).attr('data-marker');
                    changeMarker(id);
                });

                function changeMarker(id) {
                    for (i = 0; i < markers.length; i++) {
                        if (markers[i].record_id == id) {
                            google.maps.event.trigger(markers[i], 'click');
                        }
                    }
                }

                //after the user has shared his geolocation, center map, insert marker and show stores
                function centerMap(coords, map, markers) {
                    var latLng = new google.maps.LatLng(coords.latitude, coords.longitude);
                    currentLocation.search(map, coords, latLng, config, markers);
                }

                //get driving directions from user location to store
                function getDirections(map, storeDirections, userLocation, userTravelMode, directionsService, directionsDisplay) {
                    if (typeof userTravelMode === 'undefined') {
                        var directionsTravelMode = "DRIVING";
                    } else {
                        var directionsTravelMode = userTravelMode;
                    }

                    var request = {
                        destination: new google.maps.LatLng(storeDirections.latitude, storeDirections.longitude),
                        origin: new google.maps.LatLng(userLocation.latitude, userLocation.longitude),
                        travelMode: google.maps.TravelMode[directionsTravelMode]
                    };

                    directionsService.route(request, function (response, status) {
                        if (status == google.maps.DirectionsStatus.OK) {
                            directionsDisplay.setDirections(response);
                            directionsDisplay.setPanel($('.directions-panel')[0]);
                        }
                    });

                    $(".directions-panel").show();

                    //on close reset map and panel and center map to user location
                    $("body").on("click", ".directions-panel .close", function () {
                        $(".directions-panel").hide();
                        directionsDisplay.setPanel(null);
                        directionsDisplay.setMap(null);
                        centerMap(userLocation, map, markers);
                    });
                }
            });
        };
    }
);
