<?php
declare(strict_types=1);
/**
 * Limesharp_Stockists extension
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the MIT License
 * that is bundled with this package in the file LICENSE
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/mit-license.php
 *
 * @category  Limesharp
 * @package   Limesharp_Stockists
 * @copyright 2016 Claudiu Creanga
 * @license   http://opensource.org/licenses/mit-license.php MIT License
 * @author    Claudiu Creanga
 */
namespace Limesharp\Stockists\Controller\Adminhtml\Stores;

use Magento\Framework\Registry;
use Limesharp\Stockists\Api\StockistRepositoryInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Stdlib\DateTime\Filter\Date;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Limesharp\Stockists\Model\ResourceModel\Stores\CollectionFactory;
use Limesharp\Stockists\Model\Stores;

class MassGeocode extends MassAction
{
    private $geocodeController;
    private $geocodeModel;

    public function __construct(
        Registry $registry,
        StockistRepositoryInterface $stockistRepository,
        PageFactory $resultPageFactory,
        Date $dateFilter,
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        $successMessage,
        $errorMessage,
        \Limesharp\Stockists\Controller\Adminhtml\Stores\Geocode $geocodeController,
        \Limesharp\Stockists\Model\Geocode $geocodeModel
    ) {
        $this->geocodeController = $geocodeController;
        $this->geocodeModel = $geocodeModel;
        parent::__construct($registry, $stockistRepository, $resultPageFactory, $dateFilter, $context, $filter, $collectionFactory, $successMessage, $errorMessage);
    }

    /**
     * @param Stores $stockist
     * @return $this
     */
    public function massAction(Stores $stockist)
    {
        $address = $this->geocodeController->getStoreFormattedAddress($stockist);
        if(empty($address)) {
            $this->errorMessage = 'Not found an address for store' . $stockist->getStockistId();
            throw new \Exception('Not found an address for store' . $stockist->getStockistId());
        }

        try {
            $geocodeResponse = $this->geocodeModel->geocode($address);
            $stockist->setLatitude($geocodeResponse['latitude']);
            $stockist->setLongitude($geocodeResponse['longitude']);
            $stockist->save();
            $this->successMessage = 'Stores have been geocoded.';

        } catch (NoSuchEntityException $e) {
            $this->errorMessage = 'The store no longer exists.';
            throw new \Exception('The store no longer exists.');
        } catch (LocalizedException $e) {
            $this->errorMessage = $e->getMessage();
            throw new \Exception($e->getMessage());
        } catch (\Exception $e) {
            $this->errorMessage = 'There was a problem geocoding the store (' . $stockist->getStockistId() . '): ' . $e->getMessage();
            throw new \Exception('There was a problem geocoding the store (' . $stockist->getStockistId() . '): ' . $e->getMessage());
        }

        return $this;
    }
}
