define([
		'jquery',
		'stockists_individual_stores',
		'stockists_mapstyles',
		'stockists_slick',
        'mage/translate'
	],
	function($,config,mapstyles,slick, $t) {

		return function (config) {

			$(document).ready(function() {

				$.getScript("https://maps.googleapis.com/maps/api/js?sensor=false&key="+config.apiKey, function () {
					initialize();
				});

				var map;
				config.storeDetails.latitude = parseFloat(config.storeDetails.latitude);
				config.storeDetails.longitude = parseFloat(config.storeDetails.longitude);

				function initialize() {

					var mapElement = document.getElementById('map-canvas-individual');
					var loadedMapStyles = mapstyles[config.map_styles];
					var mapOptions = {
						zoom: config.zoom_individual,
						scrollwheel: false,
						center: {lat: config.storeDetails.latitude, lng: config.storeDetails.longitude},
						styles: loadedMapStyles
					};

					map = new google.maps.Map(mapElement,mapOptions);

					var image = {
						url: config.map_pin
					};
					var infowindow = new google.maps.InfoWindow({
						content: ""
					});

					function bindInfoWindow(marker, map, infowindow, data) {
						google.maps.event.addListener(marker, 'click', function() {
							var contentString = '<div class="stockists-window" data-latitude="'+marker.getPosition().lat()+'" data-longitude="'+marker.getPosition().lng()+'"><p class="stockists-title">'+data.name+'</p>'
                            if (data.external_link) {
                                var protocol_link = data.external_link.indexOf("http") > -1 ? data.external_link : "http://" + data.external_link;
                                contentString += '<p class="stockists-telephone"><a href="'+ data.protocol_link + '" target="_blank">' + data.external_link + '</a></p>'
                            } else if (data.link) {
                                contentString += '<p class="stockists-telephone"><a href="/'+config.moduleUrl+'/' + data.link + '" target="_blank">Detail page</a></p>'
                            }
							if (data.phone) {
								contentString += '<p class="stockists-telephone">'+data.phone+'</p>';
							}
							if (data.telephone) {
								contentString += '<p class="stockists-telephone">'+data.telephone+'</p>';
							}
							if (data.email) {
								contentString += '<p class="stockists-address"><a href="mailto:'+data.email+'" target="_blank">'+data.email+'</a></p>';
							}
							if (data.address) {
								contentString += '<p class="stockists-telephone">'+data.address+'</p>'
							}
							if (data.city) {
								contentString += '<p class="stockists-telephone">'+data.city+'</p>'
							}
							if (data.postcode) {
								contentString += '<p class="stockists-web">'+data.postcode+'</p>';
							}
							contentString += '<p class="ask-for-directions get-directions" data-directions="DRIVING"><a href="http://maps.google.com/maps?saddr=&daddr='+marker.getPosition().lat()+','+marker.getPosition().lng()+'" target="_blank">' + $t("Get Directions") + '</a></p>';

                            //Working Hours
                            if(data.wo_general_indication || data.wo_monday || data.wo_tuesday || data.wo_wednesday || data.wo_thursday || data.wo_friday || data.wo_saturday || data.wo_sunday) {
                                contentString += '<p class="stockists-wo-title"><strong>' + $t("Working Hours") + ':</strong></p>';
                            }
                            if(data.wo_general_indication) {
                                contentString += '<p class="stockists-wo-general">'+data.wo_general_indication+'</p>';
                            }
                            if(data.wo_monday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-monday"><strong>' + $t("Monday") + ': </strong>'+data.wo_monday+'</p>';
                            }
                            if(data.wo_tuesday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-tuesday"><strong>' + $t("Tuesday") + ': </strong>'+data.wo_tuesday+'</p>';
                            }
                            if(data.wo_wednesday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-wednesday"><strong>' + $t("Wednesday") + ': </strong>'+data.wo_wednesday+'</p>';
                            }
                            if(data.wo_thursday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-thursday"><strong>' + $t("Thursday") + ': </strong>'+data.wo_thursday+'</p>';
                            }
                            if(data.wo_friday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-friday"><strong>' + $t("Friday") + ': </strong>'+data.wo_friday+'</p>';
                            }
                            if(data.wo_saturday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-saturday"><strong>' + $t("Saturday") + ': </strong>'+data.wo_saturday+'</p>';
                            }
                            if(data.wo_sunday) {
                                contentString += '<p class="stockists-wo-day stockists-wo-sunday"><strong>' + $t("Sunday") + ': </strong>'+data.wo_sunday+'</p>';
                            }

							contentString += '</div>';
							map.setCenter(marker.getPosition());
							infowindow.setContent(contentString);
							infowindow.open(map, marker);
						});
					}

					var latLng = new google.maps.LatLng(config.storeDetails.latitude,
						config.storeDetails.longitude);

					var record_id = "" + config.storeDetails.latitude + config.storeDetails.longitude;

					var marker = new google.maps.Marker({
						record_id: record_id,
						global_name: config.storeDetails.name,
						global_address: config.storeDetails.address,
						global_city: config.storeDetails.city,
						global_postcode: config.storeDetails.postcode,
						global_country: config.storeDetails.country,
						global_image: config.storeDetails.image,
						global_schedule: config.storeDetails.schedule,
						global_link: config.storeDetails.link,
						position: latLng,
						map:map,
						icon: image,
						title: config.storeDetails.name
					});

					bindInfoWindow(marker, map, infowindow, config.storeDetails);

				}

				if (config.otherStores && config.otherStoresSlider) {
					// $('.all-stores-slider-wrapper').on(
					// 	'init',
					// 	function (event, slick) {
					// 		if ($(window).width() < 768) {
					// 			$(".all-stores-slider-wrapper").css("max-width", $(window).width() - 50 + "px");
					// 		}
					// 	}
					// );
					function initializeSlick() {
						$(".all-stores-slider-wrapper").slick({
							dots: true,
							arrows: true,
							lazyLoad: 'ondemand',
							slidesToShow: 5,
							slidesToScroll: 4,
							prevArrow: '<button id="arrow-left" type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button"><img src="' + config.slider_arrow + '" alt="Left" /></button>',
							nextArrow: '<button id="arrow-right" type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button"><img src="' + config.slider_arrow + '" alt="Right" /></button>',
							responsive: [
								{
									breakpoint: 1230,
									settings: {
										slidesToShow: 4,
										slidesToScroll: 1,
										infinite: true,
										dots: true
									}
								},
								{
									breakpoint: 1024,
									settings: {
										slidesToShow: 3,
										slidesToScroll: 1,
										infinite: true,
										dots: true,
										arrows: false
									}
								},
								{
									breakpoint: 768,
									settings: {
										slidesToShow: 2,
										slidesToScroll: 1,
										arrows: false,
										infinite: true,
										dots: true
									}
								},
								{
									breakpoint: 480,
									settings: {
										slidesToShow: 1,
										slidesToScroll: 1,
										arrows: false,
										infinite: true,
										dots: true
									}
								}
							]
						});
					}

					if ($(".all-stores-slider-wrapper").length) {
						initializeSlick();
					}
				}

			});
		};
	}
);
