<?php
declare(strict_types=1);
/**
 * Limesharp_Stockists extension
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the MIT License
 * that is bundled with this package in the file LICENSE
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/mit-license.php
 *
 * @category  Limesharp
 * @package   Limesharp_Stockists
 * @copyright 2016 Claudiu Creanga
 * @license   http://opensource.org/licenses/mit-license.php MIT License
 * @author    Claudiu Creanga
 */
namespace Limesharp\Stockists\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

/**
 * @api
 */
interface StockistInterface extends ExtensibleDataInterface
{
    /**
     * Constants for keys of data array. Identical to the name of the getter in snake case
     */
    const STOCKIST_ID         = 'stockist_id';
    const NAME                = 'name';
    const ADDRESS             = 'address';
    const CITY                = 'city';
    const POSTCODE            = 'postcode';
    const REGION              = 'region';
    const EMAIL               = 'email';
    const PHONE               = 'phone';
    const LATITUDE            = 'latitude';
    const LONGITUDE           = 'longitude';
    const LINK                = 'link';
    const STATUS              = 'status';
    const TYPE                = 'type';
    const COUNTRY             = 'country';
    const IMAGE               = 'image';
    const CREATED_AT          = 'created_at';
    const UPDATED_AT          = 'updated_at';
    const STORE_ID            = 'store_id';
    const SCHEDULE            = 'schedule';
    const INTRO               = 'intro';
    const DESCRIPTION         = 'description';
    const DISTANCE            = 'distance';
    const STATION             = 'station';
    const DETAILS_IMAGE       = 'details_image';
    const EXTERNAL_LINK       = 'external_link';

    /* Working Hours */
    const WO_GENERAL_INDICATION       = 'wo_general_indication';
    const WO_MONDAY       = 'wo_monday';
    const WP_TUESDAY       = 'wo_tuesday';
    const WO_WEDNESDAY       = 'wo_wednesday';
    const WO_THURSDAY       = 'wo_thursday';
    const WO_FRIDAY       = 'wo_friday';
    const WO_SATURDAY       = 'wo_saturday';
    const WO_SUNDAY       = 'wo_sunday';

    /**
     * Get schedule
     *
     * @return string
     */
    public function getSchedule();


    /**
     * Get intro
     *
     * @return string
     */
    public function getIntro();

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription();

    /**
     * Get external link
     *
     * @return string
     */
    public function getExternalLink();

    /**
     * Get distance
     *
     * @return string
     */
    public function getDistance();

    /**
     * Get station
     *
     * @return string
     */
    public function getStation();

    /**
     * Get store details image
     *
     * @return string
     */
    public function getDetailsImage();


    /**
     * Get name
     *
     * @return string
     */
    public function getName();

    /**
     * Get store url
     *
     * @return string
     */
    public function getLink();
    
    /**
     * Get address
     *
     * @return string
     */
    public function getAddress();
    
    /**
     * Get city
     *
     * @return string
     */
    public function getCity();
    
    /**
     * Get postcode
     *
     * @return string
     */
    public function getPostcode();
    
    /**
     * Get region
     *
     * @return string
     */
    public function getRegion();
    
    /**
     * Get email
     *
     * @return string
     */
    public function getEmail();
    
    /**
     * Get phone
     *
     * @return string
     */
    public function getPhone();
    
    /**
     * Get image
     *
     * @return string
     */
    public function getImage();
    
    /**
     * Get latitude
     *
     * @return string
     */
    public function getLatitude();
    
    /**
     * Get longitude
     *
     * @return string
     */
    public function getLongitude();

    /**
     * Get is active
     *
     * @return bool|int
     */
    public function getStatus();

    /**
     * Get type
     *
     * @return int
     */
    public function getType();

    /**
     * Get country
     *
     * @return string
     */
    public function getCountry();

    /**
     * Get updated at
     *
     * @return string
     */
    public function getUpdatedAt();

    /**
     * @return int[]
     */
    public function getStoreId();

    /**
     * Get General Indication
     *
     * @return string
     */
    public function getWoGeneralIndication();

    /**
     * Get Monday
     *
     * @return string
     */
    public function getWoMonday();

    /**
     * Get Tuesday
     *
     * @return string
     */
    public function getWoTuesday();

    /**
     * Get Wednesday
     *
     * @return string
     */
    public function getWoWednesday();

    /**
     * Get Thursday
     *
     * @return string
     */
    public function getWoThursday();

    /**
     * Get Friday
     *
     * @return string
     */
    public function getWoFriday();

    /**
     * Get Saturday
     *
     * @return string
     */
    public function getWoSaturday();

    /**
     * Get Sunday
     *
     * @return string
     */
    public function getWoSunday();

    /**
     * set name
     *
     * @param $name
     * @return StockistInterface
     */
    public function setName($name);

    /**
     * set link
     *
     * @param $link
     * @return StockistInterface
     */
    public function setLink($link);
    
    /**
     * set image
     *
     * @param $image
     * @return AuthorInterface
     */
    public function setImage($image);
    
    /**
     * set address
     *
     * @param $address
     * @return StockistInterface
     */
    public function setAddress($address);

    /**
     * set city
     *
     * @param $city
     * @return StockistInterface
     */
    public function setCity($city);
    
    /**
     * set postcode
     *
     * @param $postcode
     * @return StockistInterface
     */
    public function setPostcode($postcode);


    /**
     * set schedule
     *
     * @param $schedule
     * @return StockistInterface
     */
    public function setSchedule($schedule);

    /**
     * set description
     *
     * @param $description
     * @return StockistInterface
     */
    public function setDescription($description);

    /**
     * set distance
     *
     * @param $distance
     * @return StockistInterface
     */
    public function setDistance($distance);

    /**
     * set station
     *
     * @param $station
     * @return StockistInterface
     */
    public function setStation($station);

    /**
     * set external link
     *
     * @param $external_link
     * @return StockistInterface
     */
    public function setExternalLink($external_link);

    /**
     * set intro
     *
     * @param $intro
     * @return StockistInterface
     */
    public function setIntro($intro);

    /**
     * set store details image
     *
     * @param $details_image
     * @return StockistInterface
     */
    public function setDetailsImage($details_image);

    /**
     * set region
     *
     * @param $region
     * @return StockistInterface
     */
    public function setRegion($region);

    /**
     * set email
     *
     * @param $email
     * @return StockistInterface
     */
    public function setEmail($email);
    
    /**
     * set phone
     *
     * @param $phone
     * @return StockistInterface
     */
    public function setPhone($phone);

    /**
     * set latitude
     *
     * @param $latitude
     * @return StockistInterface
     */
    public function setLatitude($latitude);
    
    /**
     * set longitude
     *
     * @param $longitude
     * @return StockistInterface
     */
    public function setLongitude($longitude);

    /**
     * Set status
     *
     * @param $status
     * @return StockistInterface
     */
    public function setStatus($status);

    /**
     * set type
     *
     * @param $type
     * @return StockistInterface
     */
    public function setType($type);

    /**
     * Set country
     *
     * @param $country
     * @return StockistInterface
     */
    public function setCountry($country);

    /**
     * Get created at
     *
     * @return string
     */
    public function getCreatedAt();

    /**
     * set created at
     *
     * @param $createdAt
     * @return StockistInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * set updated at
     *
     * @param $updatedAt
     * @return StockistInterface
     */
    public function setUpdatedAt($updatedAt);

    /**
     * @param $storeId
     * @return StockistInterface
     */
    public function setStoreId($storeId);

    /**
     * set general indication
     *
     * @param $generalIndication
     * @return StockistInterface
     */
    public function setWoGeneralIndication($generalIndication);

    /**
     * set monday
     *
     * @param $monday
     * @return StockistInterface
     */
    public function setWoMonday($monday);

    /**
     * set thuesday
     *
     * @param $thuesday
     * @return StockistInterface
     */
    public function setWoTuesday($tuesday);

    /**
     * set wednesday
     *
     * @param $wednesday
     * @return StockistInterface
     */
    public function setWoWednesday($wednesday);

    /**
     * set thursday
     *
     * @param $thursday
     * @return StockistInterface
     */
    public function setWoThursday($thursday);

    /**
     * set friday
     *
     * @param $friday
     * @return StockistInterface
     */
    public function setWoFriday($friday);

    /**
     * set saturday
     *
     * @param $saturday
     * @return StockistInterface
     */
    public function setWoSaturday($saturday);

    /**
     * set sunday
     *
     * @param $sunday
     * @return StockistInterface
     */
    public function setWoSunday($sunday);

}
