<?php
declare(strict_types=1);
/**
 * Limesharp_Stockists extension
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the MIT License
 * that is bundled with this package in the file LICENSE
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/mit-license.php
 *
 * @category  Limesharp
 * @package   Limesharp_Stockists
 * @copyright 2016 Claudiu Creanga
 * @license   http://opensource.org/licenses/mit-license.php MIT License
 * @author    Claudiu Creanga
 */
 
namespace Limesharp\Stockists\Model;

class Route
{

    const SETTING_NO = 0;
    const SETTING_OPEN_GMAPS = 1;
    const SETTING_DRAW_ROUTE = 2;
    const SETTING_RENDER_ROUTE = 3;
    const SETTING_TRAVEL_ROUTE = 4;

    public function toOptionArray(): array
    {

        return array(
            array(
                'value' => self::SETTING_NO,
                'label' => 'No'
            ),
            array(
                'value' => self::SETTING_OPEN_GMAPS,
                'label' => 'Open on Google Maps'
            ),
            array(
                'value' => self::SETTING_DRAW_ROUTE,
                'label' => 'Simple Route without instructions (drawRoute) - TODO'
            ),
            array(
                'value' => self::SETTING_RENDER_ROUTE,
                'label' => 'Route With Direction Panel (renderRoute) - TODO'
            ),
            array(
                'value' => self::SETTING_TRAVEL_ROUTE,
                'label' => 'Route With Step by Step Info Custom Panel (travelRoute) - TODO'
            )
        );
    }
    
}
