<?php
/**
 * Geocode
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Limesharp\Stockists\Block\Adminhtml\Stores\Edit\Buttons;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class Geocode extends Generic implements ButtonProviderInterface
{
    /**
     * get button data
     *
     * @return array
     */
    public function getButtonData()
    {
        $data = [];
        if ($this->getStockistId()) {
            $data = [
                'label' => __('Geocode Store Coords'),
                'class' => 'geocode',
                'on_click' => 'deleteConfirm(\'' . __(
                        'Are you sure you want to do this?'
                    ) . '\', \'' . $this->getGeocodeCoordinatesUrl() . '\')',
                'sort_order' => 20,
            ];
        }
        return $data;
    }

    /**
     * @return string
     */
    public function getGeocodeCoordinatesUrl()
    {
        return $this->getUrl('*/*/geocode', ['stockist_id' => $this->getStockistId()]);
    }
}
