<?php
namespace Iubenda\Cookiesolution\Observer;

use Magento\Framework\Event\ObserverInterface;
use Iubenda\Cookiesolution\Helper\Data as HelperData;

class ProcessHTML implements ObserverInterface {
	protected $_helperData;
	protected $_directory_list;

	/**
	 * Class constructor
	 */
	public function __construct( HelperData $helperData, \Magento\Framework\App\Filesystem\DirectoryList $directory_list ) {
		$this->_helperData = $helperData;
		$this->_directory_list = $directory_list;  
	}

	/**
	 * Update HTML using iubenda class.
	 *
	 * @param \Magento\Framework\Event\Observer $observer
	 * @return void
	 */
	public function execute( \Magento\Framework\Event\Observer $observer ) {
		if ( $this->_helperData->is_blocking_enabled() && !$observer->getRequest()->isXmlHttpRequest()) {
			$response = $observer->getResponse();
			$output = $response->getBody();

			if ( \iubendaParser::consent_given() || \iubendaParser::bot_detected() )
				return;

			$custom_scripts = $this->_helperData->get_custom_scripts();
			$custom_iframes = $this->_helperData->get_custom_iframes();

			if ( $this->_helperData->is_experimental_mode() ){
				$iubenda = new \iubendaParser( mb_convert_encoding( $output, 'HTML-ENTITIES', 'UTF-8' ), array( 'type' => 'faster', 'scripts' => $custom_scripts, 'iframes' => $custom_iframes ) );
				$output = $iubenda->parse();
			}else{
				$iubenda = new \iubendaParser( $output, array( 'type' => 'page', 'scripts' => $custom_scripts, 'iframes' => $custom_iframes ) );
				$output = is_string($iubenda->parse()) ? $iubenda->parse() : $iubenda->parse()->__toString();
			}

			$response->setBody( $output );
		}
	}
}