<?php
namespace Iubenda\Cookiesolution\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper {
	/**
	 * Check if extension is enabled.
	 *
	 * @return bool
	 */
	public function is_blocking_enabled() {
		return $this->scopeConfig->isSetFlag( 'iubenda/settings/blocking_enabled', \Magento\Store\Model\ScopeInterface::SCOPE_STORE );
	}

	/**
	 * Check if extension use experimental mode.
	 *
	 * @return bool
	 */
	public function is_experimental_mode() {
		$value = $this->scopeConfig->getValue( 'iubenda/settings/experimental_mode', \Magento\Store\Model\ScopeInterface::SCOPE_STORE );

		if ($value==2){
			return true;
		}
		return false;
	}

	/**
	 * Get JavaScript code.
	 *
	 * @return string
	 */
	public function get_js_code() {
		return $this->scopeConfig->getValue( 'iubenda/code/jscode', \Magento\Store\Model\ScopeInterface::SCOPE_STORE );
	}

	/**
	 * Get custom scripts.
	 *
	 * @return array
	 */
	public function get_custom_scripts() {
		return array_filter( array_map( 'trim', explode( "\n", str_replace( "\r", '', $this->scopeConfig->getValue( 'iubenda/custom/scripts', \Magento\Store\Model\ScopeInterface::SCOPE_STORE ) ) ) ) );
	}

	/**
	 * Get custom iframes.
	 *
	 * @return array
	 */
	public function get_custom_iframes() {
		return array_filter( array_map( 'trim', explode( "\n", str_replace( "\r", '', $this->scopeConfig->getValue( 'iubenda/custom/iframes', \Magento\Store\Model\ScopeInterface::SCOPE_STORE ) ) ) ) );
	}
}