<?php
/**
 * Intelive
 * @package Intelive Claro
 * @copyright Copyright (c) 2018 Intelive Metrics Srl
 * @author Adrian Roman
 */

namespace Intelive\Claro\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\UrlRewrite\Model\UrlRewrite;
use Magento\Store\Model\StoreManagerInterface;

class InstallData implements InstallDataInterface
{

    protected $urlRewrite;

    public static $fields = [
        'url_rewrite_id',
        'entity_type',
        'entity_id',
        'request_path',
        'target_path',
        'redirect_type',
        'store_id',
        'description',
        'is_autogenerated',
        'metadata'
    ];

    public static $table = 'url_rewrite';

    public function __construct(UrlRewrite $urlRewrite, StoreManagerInterface $storeManager)
    {
        $this->urlRewrite = $urlRewrite;
        $this->storeManager = $storeManager;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function install(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        if (!$this->urlRewrite->getCollection()->getItemByColumnValue('request_path', 'intelive/module/abandonedcarts')) {
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/abandonedcarts',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/creditmemos',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/customers',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/invoices',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/orders',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/products',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/stocks',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $urls[] = array(
                null,
                'custom',
                0,
                'intelive/module/' . rand(1, 100000),
                'intelive/module/productcounters',
                0,
                $this->storeManager->getStore()->getId(),
                null,
                0,
                null
            );
            $setup->getConnection()->insertArray($setup->getTable(self::$table), self::$fields, $urls);
        }
    }
}
