<?php
/**
 * SessionObserver
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace FME\Restrictcustomergroup\Observer;


class SessionObserver implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Customer repository
     *
     * @var \Magento\Customer\Api\CustomerRepositoryInterface
     */
    protected $customerRepository;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * Constructor
     *
     * @param \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository
     */
    public function __construct(
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->customerRepository = $customerRepository;
        $this->logger = $logger;
    }

    /**
     * This observer update customer group in session if customer attribute has_changed_group is true.
     * Magento has
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this|void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /** @var Magento\Customer\Model\Session $customerSession */
        $customerSession = $observer->getCustomerSession();
        if(!$customerSession->isLoggedIn()) {
            return $this;
        }

        $customerId = (int) $customerSession->getCustomerId();
        if(!$customerId) {
            return $this;
        }

        try {
            $customer = $this->customerRepository->getById($customerId);
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
            return $this;
        }

        $hasChangedGroup = $customer->getCustomAttribute('has_changed_group');
        if(!$hasChangedGroup) {
            return $this;
        }

        $hasChangedGroupValue = $hasChangedGroup->getValue();
        if(!$hasChangedGroupValue) {
            return $this;
        }

        try {
            $customerSession->setCustomerGroupId($customer->getGroupId());
            $customer->setCustomAttribute('has_changed_group', 0);
            $this->customerRepository->save($customer);
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }
    }

}
