<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace FME\Restrictcustomergroup\Observer;

use Magento\Customer\Model\Session\Proxy;

class PostDispatch implements \Magento\Framework\Event\ObserverInterface
{
    protected $_ruleFactory;
    protected $_restrictcustomergroupHelper;
    protected $_storeManager;
    protected $_currentStoreView;
    protected $_layoutFactory;
    protected $_coreRegistry;
    public $filterProvider;
    protected $_productFactory;
    protected $_customerSession;
    protected $date;
    protected $_coreSession;

    /**
     * using current context to add values and
     * avoid request refresh for cookie values
     * @var \Magento\Framework\App\Http\Context
     */
    protected $_httpContext;
    /**
     *
     * @var \Magento\Framework\Url $urlBuilder
     */
    protected $_urlBuilder;

    /**
     * Page
     *
     * @var \Magento\Cms\Model\Page
     */
    protected $_page;

    protected $_redirect;
    protected $_messageManager;

    public function __construct(
        \FME\Restrictcustomergroup\Model\RuleFactory $ruleFactory,
        \FME\Restrictcustomergroup\Helper\Data $helper,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\View\Result\LayoutFactory $layoutFactory,
        \Magento\Framework\App\Http\Context $httpContext,
        \Magento\Framework\Url $urlBuilder,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Cms\Model\Template\FilterProvider $filterProvider,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Cms\Model\Page $page,
        Proxy $customerSession,
        \Magento\Framework\App\Response\Http $redirect,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \Magento\Framework\Session\SessionManagerInterface $coreSession
    ) {

        $this->_ruleFactory = $ruleFactory;
        $this->_restrictcustomergroupHelper = $helper;
        $this->_storeManager = $storeManager;
        $this->_currentStoreView = $this->_storeManager->getStore();
        $this->_layoutFactory = $layoutFactory;
        $this->_httpContext = $httpContext;
        $this->_urlBuilder = $urlBuilder;
        $this->_coreRegistry = $coreRegistry;
        $this->filterProvider = $filterProvider;
        $this->_productFactory = $productFactory;
        $this->_page = $page;
        $this->_messageManager = $messageManager;
        $this->_redirect = $redirect;
        $this->date = $date;
        $this->_customerSession = $customerSession;
        $this->_coreSession = $coreSession;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $request = $observer->getRequest();
        $url = $this->_urlBuilder->getCurrentUrl();
        $position = strpos($url, 'authorizenet');
        if ($position !== false)
        {
            return;
        }

        if (!$this->_restrictcustomergroupHelper->isEnabledInFrontend())
        {
            return;
        }

        if ($this->_restrictcustomergroupHelper->isWebCrawler($request))
        {
            return;
        }

        $restrictcustomergroup = $this->_ruleFactory->create();

        $collection = $restrictcustomergroup->getCollection()
                ->addStoreFilter([$this->_storeManager->getStore()->getId()], false)
                ->addCustomerGroupFilter($this->_customerSession->getCustomerGroupId())
                ->addStatusFilter();

        if ($collection->count() < 1)
        {
          return;
        }

        // ****************************************************
        // Redirection
        // ****************************************************
        $currentUrl = $this->_urlBuilder->getCurrentUrl();

        $ruleIds = [];
        $redirectTo = [];

        foreach ($collection as $item)
        {
          $urls = unserialize($item->getUrlSerialized());
          foreach ($urls as $key => $val)
          {
            if (in_array($currentUrl, $val))
            {
              $ruleIds[] = $item->getId(); //get rule id when matched
              $redirectTo[$item->getId()] = $urls[$key]['to']; // get correspondent url for the match
            }
          }
        }

        if (empty($redirectTo))
        {
          return;
        }
        $collection->addIdFilter($ruleIds)
                ->addPriorityFilter()
                ->addLimit();

        $firstItem = $collection->getData();

        if($url == $redirectTo[$firstItem[0]['rule_id']])
        {
          return;
        }

        $observer->getControllerAction()
                ->getResponse()
                ->setRedirect($redirectTo[$firstItem[0]['rule_id']]);
        // ****************************************************
        // Redirection End Here.
        // ****************************************************
    }
}
