<?php

/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FME\Restrictcustomergroup\Model\Rule\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class IsActive
 */
class Responsetype implements OptionSourceInterface
{

    /**
     * @var \FME\Restrictcustomergroup\Model\Rule
     */
    protected $_restrictcustomergroupRule;

    /**
     * Constructor
     *
     * @param \FME\Restrictcustomergroup\Model\Rule $_restrictcustomergroupRule
     */
    public function __construct(\FME\Restrictcustomergroup\Model\Rule $_restrictcustomergroupRule)
    {
        $this->_restrictcustomergroupRule = $_restrictcustomergroupRule;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $availableOptions = $this->_restrictcustomergroupRule->getAvailableModes();
        $options = [];
        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }

        return $options;
    }
}
