<?php

namespace FME\Restrictcustomergroup\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\DB\Adapter\AdapterInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.1.1', '<'))
        {
            /**
            * Update table 'fme_restrictcustomergroup_rule'
            */
            $tableRule = $setup->getTable('fme_restrictcustomergroup_rule');
            $setup->getConnection()->dropColumn($tableRule, 'rule_type');
            $setup->getConnection()->addColumn($tableRule, 'categories_ids', [
                'type' => Table::TYPE_TEXT,
                'nullable' => false,
                'default' => '',
                'comment' => 'Categories Ids'
            ]);

            $setup->getConnection()->addColumn($tableRule, 'start_date', [
                'type' => Table::TYPE_TEXT,
                'nullable' => false,
                'default' => '',
                'comment' => 'Start Date'
            ]);

            $setup->getConnection()->addColumn($tableRule, 'end_date', [
                'type' => Table::TYPE_TEXT,
                'nullable' => false,
                'default' => '',
                'comment' => 'End Date'
            ]);

            $setup->getConnection()->addColumn($tableRule, 'restricted_customer_response_type', [
                'type' => Table::TYPE_TEXT,
                'nullable' => false,
                'default' => '',
                'comment' => 'Restricted Customer Response Type'
            ]);

            $setup->getConnection()->addColumn($tableRule, 'redirect_url', [
                'type' => Table::TYPE_TEXT,
                'nullable' => false,
                'default' => '',
                'comment' => 'Redirect Url'
            ]);
        }

        if (version_compare($context->getVersion(), '1.1.1', '<'))
        {
          /**
          * Create table 'fme_restrictcustomergroup_category'
          */
          $tableCategory = $installer->getTable('fme_restrictcustomergroup_category');
          if ($installer->getConnection()->isTableExists($tableCategory) != true) {
              $table = $installer->getConnection()
                      ->newTable($tableCategory)
                      ->addColumn(
                          'rule_id',
                          Table::TYPE_INTEGER,
                          null,
                          [
                              'identity' => true,
                              'unsigned' => true,
                              'nullable' => false,
                              'primary' => true
                          ],
                          'Rule ID'
                      )
                      ->addColumn(
                          'category_id',
                          \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                          null,
                          [
                              'nullable' => false,
                              'primary' => true
                          ],
                          'Category ID'
                      )
                      ->addIndex(
                          $installer->getIdxName('fme_restrictcustomergroup_category', ['category_id']),
                          ['category_id']
                      )->addForeignKey(
                          $installer->getFkName(
                              'fme_restrictcustomergroup_category',
                              'rule_id',
                              'fme_restrictcustomergroup_rule',
                              'rule_id'
                          ),
                          'rule_id',
                          $installer->getTable('fme_restrictcustomergroup_rule'),
                          'rule_id',
                          \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
                      )->setComment('FME Restrictcustomergroup To Category Linkage Table');
              $installer->getConnection()->createTable($table);
          }
        }

        $setup->endSetup();
    }
}
