<?php
/**
 * UpgradeData
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace FME\Restrictcustomergroup\Setup;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Eav\Model\Config;

class UpgradeData implements UpgradeDataInterface
{
    /**
     * @var CustomerSetupFactory
     */
    private $customerSetupFactory;

    /**
     * @var AttributeSetFactory
     */
    private $attributeSetFactory;

    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * Constructor
     *
     * @param EavSetupFactory $eavSetupFactory
     * @param Config $eavConfig
     */
    public function __construct(
        EavSetupFactory $eavSetupFactory,
        Config $eavConfig
    ) {
        $this->eavSetupFactory = $eavSetupFactory;
        $this->eavConfig = $eavConfig;
    }

    /**
     * {@inheritdoc}
     */
    public function upgrade(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.1.2') < 0) {
            $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
            /* @var $eavSetup \Magento\Eav\Setup\EavSetup */
            $eavSetup->addAttribute(\Magento\Customer\Model\Customer::ENTITY, 'has_changed_group', [
                'label' => 'Has Changed Group',
                'default' => 0,
                'input' => 'boolean',
                'position' => 999,
                'required' => false,
                'system' => false,
                'visible'      => false,
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'used_in_forms', ['adminhtml_customer'],
                'type' => 'int'
            ]);
            $attribute = $this->eavConfig->getAttribute(\Magento\Customer\Model\Customer::ENTITY, 'has_changed_group');
            $attribute->setData('used_in_forms', ['adminhtml_customer']);
            $attribute->save();
        }

        $setup->endSetup();
    }
}
