<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace FME\Restrictcustomergroup\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Cms\Model\PageFactory;
use Magento\Customer\Model\GroupFactory;

class Data extends AbstractHelper
{

    protected $_customerGroupFactory;
    protected $_resource;

    /**
     * Logger
     *
     * @var \Psr\Log\LoggerInterface
     */
    protected $_logger;
    protected $_directoryList;

    /**
     * Page factory
     *
     * @var \Magento\Cms\Model\PageFactory
     */
    protected $_pageFactory;

    const XML_PATH_ENABLED = 'restrictcustomergroup/general/enable_in_frontend';

    public function __construct(
        Context $context,
        DirectoryList $directoryList,
        PageFactory $pageFactory,
        GroupFactory $groupFactory
    ) {
        parent::__construct($context);
        $this->_resource = \Magento\Framework\App\ObjectManager::getInstance()
                ->get('\Magento\Framework\App\ResourceConnection');
        $this->_logger = $context->getLogger();
        $this->_directoryList = $directoryList;
        $this->_pageFactory = $pageFactory;
        $this->_customerGroupFactory = $groupFactory;
    }

    /**
     *
     * check the module is enabled, frontend
     *
     * @param mix $store
     * @return string
     */
    public function isEnabledInFrontend($store = null)
    {

        $isEnabled = true;
        $enabled = $this->scopeConfig->getValue(self::XML_PATH_ENABLED, ScopeInterface::SCOPE_STORE);
        if ($enabled == null || $enabled == '0') {
            $isEnabled = false;
        }

        return $isEnabled;
    }

    public function isWebCrawler($request)
    {
        if (isset($_SERVER) && isset($request) && isset($_SERVER['HTTP_USER_AGENT']) && preg_match("/Googlebot/", $_SERVER['HTTP_USER_AGENT'])) {
            $remoteAddress = new \Magento\Framework\Http\PhpEnvironment\RemoteAddress($request);

            //hostname is assigned to $hostname
            $hostname = $remoteAddress->getRemoteHost();

            if (preg_match("/googlebot.com/", $hostname)) {
                // returns true if googlebot.com is found in hostname
                return true;
            }
        }
        return false;
    }

    /**
     * Get 404 file not found url
     *
     * @param string $route
     * @param array $params
     * @return string
     */
    protected function _getNotFoundUrl($route = '', $params = ['_direct' => 'core/index/notFound'])
    {
        return $this->_getUrl($route, $params);
    }

    public function getViewFileUrl()
    {
        return $this->_urlBuilder
                ->getBaseUrl(
                    ['_type' => \Magento\Framework\UrlInterface::URL_TYPE_STATIC,
                    '_current' => true]
                ) . 'adminhtml/Magento/backend/en_US/FME/Restrictcustomergroup/view/adminhtml/web/restrictcustomergroup/';
    }

    public function getCmsPageModel()
    {
        return $this->_pageFactory->create();
    }

    public function getCustomerGroupModel()
    {
        return $this->_customerGroupFactory->create();
    }
}
