<?php
/**
 * ExtendSave
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace FME\Restrictcustomergroup\Controller\Adminhtml\Index;

use \Magento\Customer\Api\CustomerMetadataInterface;

class ExtendSave extends \Magento\Customer\Controller\Adminhtml\Index\Save
{
    /**
     * Index action
     *
     * @return $this
     */
    public function execute($coreRoute = null)
    {
        $originalRequestData = $this->getRequest()->getPostValue(CustomerMetadataInterface::ENTITY_TYPE_CUSTOMER);
        $customerId = isset($originalRequestData['entity_id'])
            ? $originalRequestData['entity_id']
            : null;
        $customerGroupId = isset($originalRequestData['group_id'])
            ? $originalRequestData['group_id']
            : null;

        if(!$customerId || !$customerGroupId) {
            return parent::execute($coreRoute);
        }

        $currentCustomer = $this->_customerRepository->getById($customerId);
        $currentCustomerGroupId = $currentCustomer->getGroupId();

        if($customerId == $currentCustomerGroupId) {
            //Customer group isnt changed
            return parent::execute($coreRoute);
        }

        $originalRequestData['has_changed_group'] = 1;
        $this->getRequest()->setPostValue('customer', $originalRequestData);

        return parent::execute($coreRoute);
    }
}
