<?php
/**  
 * @category    Order
 * @package     Ests_CancelOrderEmailObserver
 * @author      ESTS Team
 * @Copyright:  Copyright (c) 2020 ESTS<expoundsofttechsolution.com>
 */

namespace Ests\CancelOrderEmail\Observer;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Store\Model\StoreManagerInterface;
/**
 * Class CancelOrderEmailObserver
 */
class CancelOrderEmailObserver implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * Email template config path
     */
    const XML_PATH_EMAIL_TEMPLATE = 'sales_email/cancelorder/email_template';

    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @var StateInterface
     */
    protected $inlineTranslation;

    /**
     * @var TransportBuilder
     */
    protected $_transportBuilder;

    /**
     * Sendmail constructor
     * @param StoreManagerInterface $storeManager
     * @param StateInterface $inlineTranslation
     * @param TransportBuilder $transportBuilder
     */
    public function __construct(StoreManagerInterface $storeManager, StateInterface $inlineTranslation, TransportBuilder $transportBuilder, \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->storeManager = $storeManager;
        $this->inlineTranslation = $inlineTranslation;
        $this->transportBuilder = $transportBuilder;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Execute observer.
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $enable = $this
            ->scopeConfig
            ->getValue('sales_email/cancelorder/enabled', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        if($enable){
        $identity = $this
            ->scopeConfig
            ->getValue('sales_email/cancelorder/identity', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $sender['email'] = $this
            ->scopeConfig
            ->getValue("trans_email/ident_" . $identity . "/email", \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $sender['name'] = $this
            ->scopeConfig
            ->getValue("trans_email/ident_" . $identity . "/name", \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $copyTo = $this
            ->scopeConfig
            ->getValue('sales_email/cancelorder/copy_to', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $copy_method = $this
            ->scopeConfig
            ->getValue('sales_email/cancelorder/copy_method', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $order = $observer->getOrder();

        $emailTempVariables = ['order' => $order, 'store' => $order->getStore() , 'customer_name' => $order->getCustomerName() , 'created_at_formatted' => $order->getCreatedAtFormatted(2) , 'order_data' => ['customer_name' => $order->getCustomerName() , 'is_not_virtual' => $order->getIsNotVirtual() , 'email_customer_note' => $order->getEmailCustomerNote() , 'frontend_status_label' => $order->getFrontendStatusLabel() ]];

        $this
            ->inlineTranslation
            ->suspend();
        try
        {

            $this
                ->transportBuilder
                ->setTemplateIdentifier($this
                ->scopeConfig
                ->getValue(self::XML_PATH_EMAIL_TEMPLATE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE))
                ->setTemplateOptions(['area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $this
                ->storeManager
                ->getStore()
                ->getId() ])
                ->setTemplateVars($emailTempVariables)->setFrom($sender)->addTo($order->getCustomerEmail() , $order->getCustomerName());

            if (!empty($copyTo) && $copy_method == 'bcc')
            {
                $copyTo = explode(",", $copyTo);
                if (is_array($copyTo))
                {
                    foreach ($copyTo as $email)
                    {
                        $this
                            ->transportBuilder
                            ->addBcc($email);
                    }
                }
                else
                {
                    $this
                        ->transportBuilder
                        ->addBcc($copyTo);
                }
            }

            if (!empty($copyTo) && $copy_method == 'copy')
            {
                $copyTo = explode(",", $copyTo);
                if (is_array($copyTo))
                {
                    foreach ($copyTo as $email)
                    {
                        $this
                            ->transportBuilder
                            ->addTo($email);
                    }
                }
                else
                {
                    $this
                        ->transportBuilder
                        ->addTo($copyTo);
                }
            }

            $transport = $this
                ->transportBuilder
                ->getTransport()
                ->sendMessage();
        }
        catch(\Exception $e)
        {
            throw new \Magento\Framework\Exception\CouldNotDeleteException(__(  $e->getMessage()));

        }
        finally
        {
            $this
                ->inlineTranslation
                ->resume();
        }
        }
    }
}