/**
 * Copyright © 2016 EspertoMagento.it All rights reserved.
 * See COPYING.txt for license details.
 */
/*browser:true*/
/*global define*/
define(
    [
        'Magento_Checkout/js/view/payment/default'
    ],
    function (Component) {
        'use strict';

        return Component.extend({
            defaults: {
                template: 'EspertoMagento_PostePay/payment/em_paym'
            },
            
            /** Returns payment method instructions */
            getInstructions: function() {
                return window.checkoutConfig.payment.instructions[this.item.method];
            },
            
            getCardNumber: function() {
                return window.checkoutConfig.payment.em_paym.card_number;
            },
            
            getCardOwner: function() {
                return window.checkoutConfig.payment.em_paym.card_owner;
            },
            
            getCfOwner: function() {
                return window.checkoutConfig.payment.em_paym.cf_owner;
            }
           
        });
    }
);
