<?php

namespace EspertoMagento\PostePay\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Escaper;
use Magento\Payment\Helper\Data as PaymentHelper;

class InstructionsPaymentConfigProvider implements ConfigProviderInterface
{

   
    protected $methodCodes = [
        EmPostePay::PAYMENT_METHOD_PAYM_CODE,
    ];

    protected $methods = [];
    protected $escaper;


    public function __construct(
        PaymentHelper $paymentHelper,
        Escaper $escaper
    ) {
        $this->escaper = $escaper;
        foreach ($this->methodCodes as $code) {
            $this->methods[$code] = $paymentHelper->getMethodInstance($code);
        }
    }
    
    public function getCheckoutConfig()
    {
        return $this->configProvider->getConfig();
    }


    public function getConfig()
    {
        $config = [];
        foreach ($this->methodCodes as $code) {
            if ($this->methods[$code]->isAvailable()) {
                $config['payment']['instructions'][$code] = $this->getInstructions($code);
            }
        }
        return $config;
    }


    protected function getInstructions($code)
    {
        return nl2br($this->escaper->escapeHtml($this->methods[$code]->getInstructions()));
    }
    

}

