<?php
/**
 * Copyright © 2016 EspertoMagento.it. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace EspertoMagento\PostePay\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Escaper;
use Magento\Payment\Helper\Data as PaymentHelper;

class EmPostePayConfigProvider implements ConfigProviderInterface
{
    /**
     * @var string[]
     */
    protected $methodCode = EmPostePay::PAYMENT_METHOD_PAYM_CODE;

    /**
     * @var Checkmo
     */
    protected $method;

    /**
     * @var Escaper
     */
    protected $escaper;

    /**
     * @param PaymentHelper $paymentHelper
     * @param Escaper $escaper
     */
    public function __construct(
        PaymentHelper $paymentHelper,
        Escaper $escaper
    ) {
        $this->escaper = $escaper;
        $this->method = $paymentHelper->getMethodInstance($this->methodCode);
    }
    
    public function getCheckoutConfig()
    {
        return $this->configProvider->getConfig();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        return $this->method->isAvailable() ? [
            'payment' => [
                'em_paym' => [
                    'card_number' => $this->getCardNumber(),
                    'card_owner' => $this->getCardOwner(),
                    'cf_owner' => $this->getCfOwner(),
                ],
            ],
        ] : [];
    }

    /**
     * Get mailing address from config
     *
     * @return string
     */
    protected function getCardNumber()
    {
        return $this->method->getCardNumber();
    }

    /**
     * Get payable to from config
     *
     * @return string
     */
    protected function getCardOwner()
    {
        return $this->method->getCardOwner();
    }
    
        protected function getCfOwner()
    {
        return $this->method->getCfOwner();
    }
}
