<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace EspertoMagento\PostePay\Model;



/**
 * Pay In Store payment method model
 */
class EmPostePay extends \Magento\Payment\Model\Method\AbstractMethod
{

    const PAYMENT_METHOD_PAYM_CODE = 'em_paym';

    /**
     * Payment method code
     *
     * @var string
     */
    protected $_code = self::PAYMENT_METHOD_PAYM_CODE;


    /**
     * Instructions block path
     *
     * @var string
     */
    protected $_infoBlockType = 'EspertoMagento\PostePay\Block\Info\EmPostePay';

    /**
     * Availability option
     *
     * @var bool
     */
    protected $_isOffline = true;


    public function getInstructions()
    {
        return trim($this->getConfigData('instructions'));
    }
    
    public function getCardNumber()
    {
        return trim($this->getConfigData('card_number'));
    }
    
    public function getCardOwner()
    {
        return trim($this->getConfigData('card_owner'));
    }
    
    public function getCfOwner()
    {
        return trim($this->getConfigData('cf_owner'));
    }
    
}
