<?php
/**
 * Copyright © 2016 EspertoMagento.it. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace EspertoMagento\PostePay\Block\Info;


class EmPostePay extends \Magento\Payment\Block\Info
{

   protected $_template = 'EspertoMagento_PostePay::info/em_paym.phtml';

   const XML_PATH_CARD_NUMBER = 'payment/em_paym/card_number';
   const XML_PATH_CARD_OWNER = 'payment/em_paym/card_owner';
   const XML_PATH_CF_OWNER = 'payment/em_paym/cf_owner';
   const XML_PATH_INSTRUCTIONS = 'payment/em_paym/instructions';

    
    public function getInstructions()
    {
    	$objectManager = \Magento\Framework\App\ObjectManager::getInstance(); 
        return $objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')->getValue(self::XML_PATH_INSTRUCTIONS);
    }
    
    public function getCardNumber()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance(); 
        return $objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')->getValue(self::XML_PATH_CARD_NUMBER);
    }
    
    public function getCardOwner()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance(); 
        return $objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')->getValue(self::XML_PATH_CARD_OWNER);
    }
    
    public function getCfOwner()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance(); 
        return $objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')->getValue(self::XML_PATH_CF_OWNER);
    }




}
