<?php
/**
 * Created by PhpStorm.
 * User: maintux
 * Date: 22/01/17
 * Time: 09:30
 */
namespace EasyNolo\BancaSellaPro\Model\Config\Source;

class Currency implements \Magento\Framework\Option\ArrayInterface {
    
    public function toOptionArray()
    {
        $currencies = [
            ['value' => 187, 'label'=>'AED United Arab Emirates dirham'],
            ['value' => 216, 'label'=>'ARS Peso Argentina'],
            ['value' => 109, 'label'=>'AUD Australian dollar'],
            ['value' => 262, 'label'=>'BGN Bulgarian lev'],
            ['value' => 234, 'label'=>'BRL Brazilian real'],
            ['value' => 12, 'label'=>'CAD Canadian dollar'],
            ['value' => 3, 'label'=>'CHF Swiss franc'],
            ['value' => 144, 'label'=>'CNY Chinese yuan'],
            ['value' => 223, 'label'=>'CZK Czech koruna'],
            ['value' => 7, 'label'=>'DKK Danish krone'],
            ['value' => 242, 'label'=>'EUR Euro'],
            ['value' => 2, 'label'=>'GBP Pound sterling'],
            ['value' => 103, 'label'=>'HKD Hong Kong dollar'],
            ['value' => 2290, 'label'=>'HRK Croatian kuna'],
            ['value' => 1530, 'label'=>'HUF Hungarian forint'],
            ['value' => 1230, 'label'=>'IDR Indonesian rupiah'],
            ['value' => 2030, 'label'=>'ILS Israeli new shekel'],
            ['value' => 31, 'label'=>'INR Indian rupee'],
            ['value' => 62, 'label'=>'ISK Icelandic króna'],
            ['value' => 71, 'label'=>'JPY Japanese yen'],
            ['value' => 119, 'label'=>'KRW South Korean won'],
            ['value' => 55, 'label'=>'MYR Malaysian ringgit'],
            ['value' => 81, 'label'=>'NGN Nigerian naira'],
            ['value' => 8, 'label'=>'NOK Norwegian krone'],
            ['value' => 113, 'label'=>'NZD New Zealand dollar'],
            ['value' => 66, 'label'=>'PHP hilippine peso'],
            ['value' => 26, 'label'=>'PKR Pakistani rupee'],
            ['value' => 237, 'label'=>'PLN Polish złoty'],
            ['value' => 270, 'label'=>'RON Romanian leu'],
            ['value' => 244, 'label'=>'RUB Russian ruble'],
            ['value' => 75, 'label'=>'SAR Saudi riyal'],
            ['value' => 9, 'label'=>'SEK Swedish krona/kronor'],
            ['value' => 124, 'label'=>'SGDSingapore dollar'],
            ['value' => 73, 'label'=>'THB Thai baht'],
            ['value' => 267, 'label'=>'TRY Turkish lira'],
            ['value' => 143, 'label'=>'TWD New Taiwan dollar'],
            ['value' => 241, 'label'=>'UAH Ukrainian hryvnia'],
            ['value' => 1, 'label'=>'USD United States dollar'],
            ['value' => 145, 'label'=>'VND Vietnamese đồng'],
            ['value' => 82, 'label'=>'ZAR South African rand'],
        ];
        
        return $this->_sortOptionArray($currencies);
    }

    public function _sortOptionArray($option)
    {
        $data = array();
        foreach ($option as $item) {
            $data[$item['value']] = $item['label'];
        }        
        asort($data);
        $option = array();
        foreach ($data as $key => $label) {
            $option[] = array(
               'value' => $key,
               'label' => $label
            );
        }
        return $option;
    }
}