<?php

namespace EasyNolo\BancaSellaPro\Helper;

class Riskified extends \Magento\Framework\App\Helper\AbstractHelper
{

    public function addParams(&$params, $order = null){
        $paymentParams = $params;
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $customerSession = $objectManager->create('Magento\Customer\Model\Session');
        $beaconSessionID = $customerSession->getSessionId();
        if(!$order || !$order->getId()) return;
        if(!$beaconSessionID) return;

        $gestpay = $order->getPayment()->getMethodInstance();
        $additionalData = $gestpay->getInfoInstance()->getAdditionalInformation();
        $method = array();
        if (!empty($additionalData) && !empty($additionalData['alternative-payment'])) {
            $alternativeHelper = $objectManager->create('EasyNolo\BancaSellaPro\Helper\AlternativePayments');
            $alternatives = $alternativeHelper->getAlternativePayments();
            if (!empty($alternatives) && !empty($alternatives[$additionalData['alternative-payment']])) {
                $method = $alternatives[$additionalData['alternative-payment']];
            }
        }

        $params['OrderDetails'] = array();
        $params['OrderDetails']['FraudPrevention'] = array();
        $params['OrderDetails']['FraudPrevention']['SubmitForReview'] = 1;
        $createdAt = $order->getCreatedAt();
        $orderDate = date('Y-m-d', strtotime($createdAt));
        $params['OrderDetails']['FraudPrevention']['OrderDateTime'] = $orderDate;
        $params['OrderDetails']['FraudPrevention']['Source'] = 'website';
        $params['OrderDetails']['FraudPrevention']['SubmissionReason'] = 'rule_decision';
        $params['OrderDetails']['FraudPrevention']['BeaconSessionID'] = $beaconSessionID;

        if($gestpay->getRiskifiedConfigData('customer_data')) {
            $params['OrderDetails']['CustomerDetail'] = array();
            $params['OrderDetails']['CustomerDetail']['FirstName'] = ($order->getCustomerFirstname()) ? $order->getCustomerFirstname() : $order->getBillingAddress()->getFirstName();
            $params['OrderDetails']['CustomerDetail']['Lastname'] = ($order->getCustomerLastname()) ? $order->getCustomerLastname() : $order->getBillingAddress()->getLastName();
            $params['OrderDetails']['CustomerDetail']['PrimaryEmail'] = $order->getCustomerEmail();
            if ($order->getCustomerDob()) {
                $params['OrderDetails']['CustomerDetail']['DateOfBirth'] = date('d/m/Y', strtotime($order->getCustomerDob()));
            }
            $customer = $customerSession->getCustomer();
            $params['OrderDetails']['CustomerDetail']['VerifiedEmail'] = ($customer->getConfirmation() == '') ? 'true' : 'false';
            $params['OrderDetails']['CustomerDetail']['MerchantCustomerID'] = $order->getCustomerId();
            $params['OrderDetails']['CustomerDetail']['CreatedAtDate'] = date('Y-m-d H:i', strtotime($customer->getCreatedAt()));
            $params['OrderDetails']['CustomerDetail']['AccountType'] = ($customer->getCustomerIsGuest()) ? 'guest' : 'registered';
            if(isset($method['type']) && $method['type'] == 'KLARNA') {
                if(!empty($paymentParams['OrderDetails']['CustomerDetail']['PrimaryPhone'])) {
                    $params['OrderDetails']['CustomerDetail']['PrimaryPhone'] = $paymentParams['OrderDetails']['CustomerDetail']['PrimaryPhone'];
                }
                if(!empty($paymentParams['OrderDetails']['CustomerDetail']['SocialSecurityNumber'])) {
                    $params['OrderDetails']['CustomerDetail']['SocialSecurityNumber'] = $paymentParams['OrderDetails']['CustomerDetail']['SocialSecurityNumber'];
                }
            }
        }

        if (!$order->getIsVirtual()) {
            if ($gestpay->getRiskifiedConfigData('shipping_info')) {
                $shipping_address = $order->getShippingAddress();
                $params['OrderDetails']['ShippingAddress'] = array();
                $params['OrderDetails']['ShippingAddress']['FirstName'] = $shipping_address->getFirstname();
                $params['OrderDetails']['ShippingAddress']['Lastname'] = $shipping_address->getLastname();
                $params['OrderDetails']['ShippingAddress']['Email'] = $shipping_address->getEmail();
                $params['OrderDetails']['ShippingAddress']['StreetName'] = $shipping_address->getData('street');
                $params['OrderDetails']['ShippingAddress']['City'] = $shipping_address->getCity();
                $params['OrderDetails']['ShippingAddress']['CountryCode'] = $shipping_address->getCountryId();
                $params['OrderDetails']['ShippingAddress']['ZipCode'] = $shipping_address->getPostcode();
                $params['OrderDetails']['ShippingAddress']['PrimaryPhone'] = $shipping_address->getTelephone();
            }
        }

        if($gestpay->getRiskifiedConfigData('billing_info')) {
            $billing_address = $order->getBillingAddress();
            $params['OrderDetails']['BillingAddress'] = array();
            $params['OrderDetails']['BillingAddress']['FirstName'] = $billing_address->getFirstname();
            $params['OrderDetails']['BillingAddress']['Lastname'] = $billing_address->getLastname();
            $params['OrderDetails']['BillingAddress']['Email'] = $billing_address->getEmail();
            $params['OrderDetails']['BillingAddress']['StreetName'] = $billing_address->getData('street');
            $params['OrderDetails']['BillingAddress']['City'] = $billing_address->getCity();
            $params['OrderDetails']['BillingAddress']['CountryCode'] = $billing_address->getCountryId();
            $params['OrderDetails']['BillingAddress']['ZipCode'] = $billing_address->getPostcode();
            $params['OrderDetails']['BillingAddress']['PrimaryPhone'] = $billing_address->getTelephone();
            if(isset($method['type']) && $method['type'] == 'KLARNA') {
                if(!empty($paymentParams['OrderDetails']['BillingAddress']['StreetName'])) {
                    $params['OrderDetails']['BillingAddress']['StreetName'] = $paymentParams['OrderDetails']['BillingAddress']['StreetName'];
                }
                if(!empty($paymentParams['OrderDetails']['BillingAddress']['StreetNumber'])) {
                    $params['OrderDetails']['BillingAddress']['StreetNumber'] = $paymentParams['OrderDetails']['BillingAddress']['StreetNumber'];
                }
                if(!empty($paymentParams['OrderDetails']['BillingAddress']['HouseNumber'])) {
                    $params['OrderDetails']['BillingAddress']['HouseNumber'] = $paymentParams['OrderDetails']['BillingAddress']['HouseNumber'];
                }
                if(!empty($paymentParams['OrderDetails']['BillingAddress']['HouseExtention'])) {
                    $params['OrderDetails']['BillingAddress']['HouseExtention'] = $paymentParams['OrderDetails']['BillingAddress']['HouseExtention'];
                }
                if(!empty($paymentParams['OrderDetails']['BillingAddress']['State'])) {
                    $params['OrderDetails']['BillingAddress']['State'] = $paymentParams['OrderDetails']['BillingAddress']['State'];
                }
            }
        }
        if(isset($method['type']) && $method['type'] == 'KLARNA') {
            $params['OrderDetails']['ProductDetails'] = $paymentParams['OrderDetails']['ProductDetails'];
        } else {
            if($gestpay->getRiskifiedConfigData('product_details') || (isset($method['type']) && $method['type'] == 'S2PYAN')) {
                $params['OrderDetails']['ProductDetails']['ProductDetail'] = array();
                foreach($order->getAllItems() as $order_item) {

                    if($order_item->getParentItem())continue;

                    $type = 1;
                    if ($order_item->getProduct()->getIsVirtual())
                    {
                        $type = 8;
                    }
                    else{
                        $type = 5;
                    }
                    
                    $addiotional_array = array();
                    if(isset($method['type']) && $method['type'] == 'S2PYAN') {
                        $vat = (int)$order_item->getTaxPercent();

                        $taxType = 0;
                        if($vat == 0)
                        {
                            $taxType = 1;
                        }
                        elseif($vat == 10)
                        {
                            $taxType = 3;
                        }
                        elseif($vat == 18)
                        {
                            $taxType = 4;
                        }
                        $addiotional_array = array('TaxType' => $taxType);
                    }

                    $input_param_array = array(
                        'ProductCode' => $order_item->getId(),
                        'Name' => $order_item->getName(),
                        'SKU' => $order_item->getSku(),
                        'Quantity' => (int)$order_item->getQtyOrdered(),
                        'UnitPrice' => round($order_item->getPrice(), 2),
                        'Price' => round($order_item->getRowTotalInclTax(), 2),
                        'Type' => $type,
                        'Vat' => (int)round($order_item->getTaxPercent()),
                        'RequiresShipping' => !$order_item->getProduct()->getIsVirtual() ? 'true' : 'false',
                        'Brand' => $order_item->getProduct()->getData('manufacturer') ? $order_item->getProduct()->getAttributeText('manufacturer') : '',
                    );
                    $params['OrderDetails']['ProductDetails']['ProductDetail'][] = array_merge($input_param_array, $addiotional_array);
                }
                if (!$order->getIsVirtual()) {
                    $params['OrderDetails']['ShippingLines']['ShippingLine'] = array(
                        'Price' => round($order->getShippingAmount(), 2),
                        'Title' => $order->getShippingDescription(),
                        'Code' => $order->getShippingMethod(),
                    );
                }
            }
        }
    }
}