<?php
namespace EasyNolo\BancaSellaPro\Helper\AlternativePayments;

class Yandex extends \Magento\Framework\App\Helper\AbstractHelper {

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \EasyNolo\BancaSellaPro\Helper\Data $dataHelper,
        \Magento\Sales\Model\Order $orderModel,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
    )
    {

        $this->dataHelper = $dataHelper;
        $this->orderModel = $orderModel;
        $this->productRepository = $productRepository;    
        parent::__construct($context);
    }

    public function getEncryptParams(\Magento\Sales\Model\Order $order){
        $gestpay = $order->getPayment()->getMethodInstance();
        $rsk_productDetails = array();
        if (!$gestpay->isRiskifiedEnabled()) {
            //productDetails                       
            $count = 0;
            foreach ($order->getAllItems() as $item) 
            {
                $product = $this->productRepository->getById($item->getProductId());
                $rsk_productDetails['ProductDetail'][$count]['ProductCode'] = $this->dataHelper->normalize($item->getProductId());
                $rsk_productDetails['ProductDetail'][$count]['SKU'] = $this->dataHelper->normalize($item->getSku(), 50);
                $rsk_productDetails['ProductDetail'][$count]['Name'] = $this->dataHelper->normalize($item->getName(), 100);
                $rsk_productDetails['ProductDetail'][$count]['Description'] = $this->dataHelper->normalize($product->getShortDescription(), 255);
                $rsk_productDetails['ProductDetail'][$count]['Quantity'] = (string)round($item->getQtyOrdered());
                $rsk_productDetails['ProductDetail'][$count]['Price'] = (string)round($item->getRowTotalInclTax(),2);
                $rsk_productDetails['ProductDetail'][$count]['UnitPrice'] = (string)round($item->getPrice(),2);
                
                if ($item->getProduct()->getIsVirtual())
                {
                    $type = 8;
                }
                else{
                    $type = 5;
                }                       

                $vat = (int)$item->getTaxPercent();
                $rsk_productDetails['ProductDetail'][$count]['Type'] = $type;
                $rsk_productDetails['ProductDetail'][$count]['Vat'] = $vat;

                // if(strtoupper($paymentType) == 'S2PYAN')//For Yandex payment
                // {
                    $taxType = 0;
                    if($vat == 0)
                    {
                        $taxType = 1;
                    }
                    elseif($vat == 10)
                    {
                        $taxType = 3;
                    }
                    elseif($vat == 18)
                    {
                        $taxType = 4;
                    }
                    $rsk_productDetails['ProductDetail'][$count]['TaxType'] = $taxType;
                // }
                
                $rsk_productDetails['ProductDetail'][$count]['RequiresShipping'] = $item->getProduct()->getIsVirtual() ? 'false' : 'true';
                $rsk_productDetails['ProductDetail'][$count]['Condition'] = "";
                $rsk_productDetails['ProductDetail'][$count]['Seller'] = "";
                $rsk_productDetails['ProductDetail'][$count]['Category'] = "";
                $rsk_productDetails['ProductDetail'][$count]['SubCategory'] = "";
                $rsk_productDetails['ProductDetail'][$count]['Brand'] = "";
                $rsk_productDetails['ProductDetail'][$count]['DeliveryAt'] = "";
                $count++;
            }
            $params['orderDetails']['productDetails'] = $rsk_productDetails;
            return $params;
        }
    }

}
