<?php
/**
 * Created by PhpStorm.
 * User: maintux
 * Date: 05/02/17
 * Time: 14:44
 */
namespace EasyNolo\BancaSellaPro\Controller\Gestpay;
use \Magento\Framework\App\Action\Context;
use \Magento\Framework\App\Request\Http;
use \Magento\Checkout\Model\Session;
use \Magento\Quote\Model\Quote;
use \Magento\Framework\Registry;
use \Magento\Customer\Model\Session as CustomerSession;
use \Magento\Sales\Model\Order as OrderRepository;
use \EasyNolo\BancaSellaPro\Helper\Data as GestpayData;
use \EasyNolo\BancaSellaPro\Model\WS\WS2S;

class Confirm3dS2S extends \Magento\Framework\App\Action\Action
{
    protected $helper, $_order, $resultRedirectFactory, $checkoutSession, $_request, $_quote, $s2s, $_registry, $_sessionFactory, $_orderRepository;

    public function __construct(
        Context $context,
        GestpayData $dataHelper,
        Session $checkoutSession,
        Http $request,
        WS2S $s2s,
        Quote $quote,
        Registry $registry,
        CustomerSession $sessionFactory,
        OrderRepository $orderRepository
    )
    {
        $this->helper = $dataHelper;
        $this->_order = $checkoutSession->getLastRealOrder();
        $this->resultRedirectFactory = $context->getResultRedirectFactory();
        $this->_request = $request;
        $this->checkoutSession = $checkoutSession;
        $this->s2s = $s2s;
        $this->_quote = $quote;
        $this->_registry = $registry;
        $this->_sessionFactory = $sessionFactory;
        $this->_orderRepository = $orderRepository;
        return parent::__construct($context);
    }

    public function getRequest()
    {
        return $this->_request;
    }

    public function execute()
    {
        if (empty($this->getRequest()->get('PaRes'))) {
            $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false;
            $this->helper->log('direct access restricted :'. $ip);
            echo "<h1>Oops!! Access restricted!</h1>"; exit;
        }
        $resultRedirect = $this->resultRedirectFactory->create();
        $this->helper->log('Richiamata azione conferma 3dsecure');
        $orderIdFromUrl = (!empty($this->getRequest()->getParam('oid'))) ? base64_decode($this->getRequest()->getParam('oid')) : false;
        $transactionKeyFromUrl = (!empty($this->getRequest()->getParam('tkey'))) ? base64_decode($this->getRequest()->getParam('tkey')) : false;
        if($transactionKeyFromUrl && !$this->checkoutSession->getGestpayTransactionKey()) {
            $this->checkoutSession->setGestpayTransactionKey($transactionKeyFromUrl); 
            $this->helper->log("transaction key from URL:". $transactionKeyFromUrl);
        }
        if(!$this->_order->getId() && $orderIdFromUrl){
            $this->helper->log("order loaded from URL:". $orderIdFromUrl);
            $this->_order = $this->_orderRepository->loadByIncrementId($orderIdFromUrl); 
            $this->checkoutSession->setLastRealOrderId($orderIdFromUrl);
            $this->checkoutSession->setLastOrderId($this->_order->getId()); // Required, otherwise getOrderId() is empty on success.phtml

        }
        if(!$this->checkoutSession->getLastQuoteId()){
            $this->checkoutSession->setLastQuoteId($this->_order->getQuoteId());
            $this->helper->log("set quote id from order:". $this->checkoutSession->getLastQuoteId());
        }

        $isCustomerloggedIn = $this->_sessionFactory->isLoggedIn();
        if(!$isCustomerloggedIn && !$this->_order->getCustomerIsGuest() && $this->_order->getCustomerId()) {
            $customer_id = $this->_order->getCustomerId();
            $this->_sessionFactory->loginById($customer_id);
            $this->helper->log("logged in customer from id");
        }
        $this->helper->getStoreFromOrder();
        $this->helper->log("order id before pares:".$this->_order->getId());
        if($this->_order->getId()){
            $this->_order->addStatusHistoryComment(__('User is redirecting to issuing bank for 3d authentification.'));
            $paRes = $this->getRequest()->get('PaRes');
            $paRes = $this->helper->normalizePARes($paRes);
            $transactionKey = $this->checkoutSession->getGestpayTransactionKey();
            $order = $this->_order;
            $method = $order->getPayment()->getMethodInstance();

            $params = $this->helper->getGestpayParams($order);
            unset($params['requestToken']);
            $params['PARes'] = $paRes;
            $params['transKey'] = $transactionKey;

            $result = $this->s2s->executePaymentS2S($params);
            $this->helper->saveDecryptResponse($result);
            $this->helper->log("customer loggedin before redirection:". $this->_sessionFactory->isLoggedIn());
            if(!$result->getTransactionResult() || $result->getTransactionResult() == 'KO') {
                if ($lastQuoteId = $this->checkoutSession->getLastQuoteId()) {
                    $quote = $this->_quote->load($lastQuoteId);
                    if ($quoteId = $quote->getId()) {
                        $quote->setIsActive(true);
                        $quote->setReservedOrderId(null);
                        $quote->save();
                        $this->checkoutSession->setQuoteId($quoteId);
                    }
                }
                $this->messageManager->addError($result->getErrorDescription());
                $redirect = 'checkout/cart';
            } else {

                $method->setStatusOrderByS2SRequest($order, $result);
                if ($order->getStatus() != \Magento\Sales\Model\Order::STATUS_FRAUD && $method->getConfigData('use_s2s_api')) {
                    $this->helper->log('Invio email di conferma creazione ordine all\'utente');
                    $callReadParams = array();
                    $callReadParams['shopLogin'] = $method->getConfigData('merchant_id');
                    $callReadParams['shopTransactionId'] = $order->getIncrementId();
                    $callReadParams['bankTransactionId'] = $result->getBankTransactionID();

                    $apikey = $method->getConfigData('api_key');
                    if(!empty(trim($apikey))) {
                        $callReadParams['apikey'] = $apikey;
                    }
                    $this->helper->log('callReadTrx params for 3D token transaction');
                    $this->helper->log($callReadParams);
                    $callReadResult = $this->s2s->executeCallReadTrxS2S($callReadParams);
                    $this->helper->log("customer loggedin on confirm3ds2s exit:". $this->_sessionFactory->isLoggedIn());
                    if ($callReadResult->getTransactionResult() == 'OK' && $method->isRiskifiedEnabled() && ($callReadResult->getRiskResponseCode() == 'approved')) {
                        $this->helper->_checkEmailSend($order);
                    }
                    //$order->sendNewOrderEmail();
                }
                $order->save();
                if(!$this->checkoutSession->getLastSuccessQuoteId()) {
                    $this->checkoutSession->setLastSuccessQuoteId($this->checkoutSession->getLastQuoteId());
                    $this->helper->log("set success quote id:". $this->checkoutSession->getLastSuccessQuoteId());
                }
                
                // reset quote on checkout session
                if ($lastQuoteId = $this->checkoutSession->getLastQuoteId()) {
                    $quote = $this->_quote->load($lastQuoteId);
                    if ($quoteId = $quote->getId()) {
                        $quote->setIsActive(false)->save();
                        $this->checkoutSession->setQuoteId(null);
                    }
                }

                $redirect ='checkout/onepage/success';
            }

            $this->_order->save();

            $this->helper->log("redirected successfully to:". $redirect);
            return $resultRedirect->setPath($redirect);
        }

        return $resultRedirect->setPath('/');
    }

    protected function redirectInCorrectStore($store, $path, $arguments = array())
    {
        $params = array_merge(
            $arguments,
            array(
                '_use_rewrite' => false,
                '_store' => $store,
                '_store_to_url' => true,
                '_secure' => $store->isCurrentlySecure()
            ) );
        $url = $this->_urlBuilder->getUrl($path, $params);

        $this->getResponse()->setRedirect($url);
        return;
    }

}