<?php
/**
 * Created by PhpStorm.
 * User: maintux
 * Date: 23/02/17
 * Time: 10:42
 */

namespace EasyNolo\BancaSellaPro\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\DB\Ddl\Table;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        // Get tutorial_simplenews table
        $tableName = $installer->getTable('easynolo_bancasellapro_token');

        // Check if the table already exists
        if ($installer->getConnection()->isTableExists($tableName) != true) {
            // Create tutorial_simplenews table
            $table = $installer->getConnection()
                ->newTable($tableName)
                ->addColumn(
                    'id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true
                    ],
                    'ID'
                )
                ->addColumn(
                    'profile_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['nullable' => true, 'unsigned' => true],
                    'Profile ID'
                )
                ->addColumn(
                    'customer_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'unsigned' => true],
                    'Customer ID'
                )
                ->addColumn(
                    'token',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => false],
                    'Token'
                )
                ->addColumn(
                    'created_at',
                    Table::TYPE_DATETIME,
                    null,
                    ['nullable' => false],
                    'Created At'
                )
                ->addColumn(
                    'expire_at',
                    Table::TYPE_DATETIME,
                    null,
                    ['nullable' => false],
                    'Expire At'
                )
                ->setComment('Banca Sella Tokens')
                ->setOption('type', 'InnoDB')
                ->setOption('charset', 'utf8');
            $installer->getConnection()->createTable($table);
        }

        // Get tutorial_simplenews table
        $responseTableName = $installer->getTable('easynolo_bancasellapro_payment_response');

        // Check if the table already exists
        if ($installer->getConnection()->isTableExists($responseTableName) != true) {
            // Create tutorial_simplenews table
            $responseTable = $installer->getConnection()
                ->newTable($responseTableName)
                ->addColumn(
                    'id',
                    Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => true,
                        'unsigned' => true,
                        'nullable' => false,
                        'primary' => true
                    ],
                    'ID'
                )
                ->addColumn(
                    'transaction_type',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Transaction Type'
                )
                ->addColumn(
                    'transaction_result',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Transaction Result'
                )
                ->addColumn(
                    'shop_transaction_i_d',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Shop Transaction ID'
                )
                ->addColumn(
                    'bank_transaction_i_d',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Bank Transaction ID'
                )
                ->addColumn(
                    'currency',
                    Table::TYPE_INTEGER,
                    null,
                    ['nullable' => true],
                    'Currency'
                )
                ->addColumn(
                    'amount',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Amount'
                )
                ->addColumn(
                    'payment_method',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Payment Method'
                )
                ->addColumn(
                    'token',
                    Table::TYPE_TEXT,
                    null,
                    ['nullable' => true],
                    'Token'
                )
                ->addColumn(
                    'created_at',
                    Table::TYPE_DATETIME,
                    null,
                    ['nullable' => true],
                    'Created At'
                )
                ->setComment('Banca Sella Payment Response')
                ->setOption('type', 'InnoDB')
                ->setOption('charset', 'utf8');
            $installer->getConnection()->createTable($responseTable);
        }

        $installer->endSetup();
    }
}