<?php
namespace EasyNolo\BancaSellaPro\Helper\AlternativePayments;

use Magento\Framework\App\Config\ScopeConfigInterface;

class Paypal extends \Magento\Framework\App\Helper\AbstractHelper {

    public function getEncryptParams(\Magento\Sales\Model\Order $order){

        $params = array();

        $storeId = $order->getStoreId();
        $showProductInfo = (bool)$this->scopeConfig->getValue(
            'payment/easynolo_bancasellapro_alternative/paypal_show_product_info',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );
        $sellerProtection = (bool)$this->scopeConfig->getValue(
            'payment/easynolo_bancasellapro_alternative/paypal_seller_protection',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );

        if ($showProductInfo) {
            $params['OrderDetails'] = array();
            $params['OrderDetails']['ProductDetails'] = array();
            foreach($order->getAllItems() as $order_item) {

                $type = 1;
                if ($order_item->getProduct()->getIsVirtual())
                {
                    $type = 8;
                }
                else{
                    $type = 5;
                }

                $params['OrderDetails']['ProductDetails']['ProductDetail'][] = array(
                    'ProductCode' => $order_item->getId(),
                    'Name' => $order_item->getName(),
                    'SKU' => $order_item->getSku(),
                    'Description' => $order_item->getName(),
                    'Quantity' => (int)$order_item->getQtyOrdered(),
                    'UnitPrice' => round($order_item->getPrice(), 2),
                    'Price' => round($order_item->getRowTotalInclTax(), 2),
                    'Type' => $type,
                    'Vat' => (int) $order_item->getTaxPercent(),
                    'Discount' => round($order_item->getDiscountAmount(), 2)
                );
            }

            if (round($order->getShippingAmount(), 2) > 0.001) {
                //add shipping costs
                $params['OrderDetails']['ProductDetails']['ProductDetail'][] = array(
                    'ProductCode' => $order->getShippingMethod(),
                    'Name' => $order->getShippingDescription(),
                    'SKU' => $order->getShippingMethod(),
                    'Description' => $order->getShippingDescription(),
                    'Quantity' => 1,
                    'UnitPrice' => round($order->getShippingAmount(), 2),
                    'Price' => round($order->getShippingAmount(), 2),
                    'Type' => 2,
                    'Vat' => $order->getShippingTaxAmount() > 0.001 ? round($order->getShippingTaxAmount() / $order->getShippingInclTax(), 2) : 0,
                    'Discount' => round($order->getShippingDiscountAmount(), 2)
                );
            }
        }

        if ($sellerProtection) {
            $params['ppSellerProtection'] = 1;
            $shipping_address = $order->getShippingAddress() ? $order->getShippingAddress() : $order->getBillingAddress();
            $params['shippingDetails'] = array();
            $params['shippingDetails']['shipToName'] = $shipping_address->getFirstname().' '.$shipping_address->getLastname();
            $params['shippingDetails']['shipToStreet'] = $shipping_address->getStreetLine(1);
            $params['shippingDetails']['shipToCity'] = $shipping_address->getCity();
            $params['shippingDetails']['shipToState'] = $shipping_address->getRegion();
            $params['shippingDetails']['shipToCountryCode'] = $shipping_address->getCountryId();
            $params['shippingDetails']['shipToZip'] = $shipping_address->getPostcode();
            $params['shippingDetails']['shipToStreet2'] = $shipping_address->getStreetLine(2);
        }

        return $params;
    }

}
