<?php

namespace EasyNolo\BancaSellaPro\Block\System\Config\Form;
use Magento\Framework\Data\Form\Element\AbstractElement;

class Fieldset extends \Magento\Config\Block\System\Config\Form\Fieldset
{    
    public function render(AbstractElement $element)
    {
        $this->setElement($element);
        $header = $this->_getHeaderHtml($element);

        $elements = $this->_getChildrenElementsHtml($element);

        $footer = $this->_getFooterHtml($element);

        return $header . $elements . $footer;
    }
    
    protected function _getHeaderTitleHtml($element)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $block = $objectManager->create('Magento\Framework\View\Element\Template');
        $logoSrc = $block->getViewFileUrl('EasyNolo_BancaSellaPro::images/axerve-logo.png');
        
        $logo = '<img style="width:100px;position: absolute;top: 5px;left: 30px" src="'.$logoSrc.'"/>';

        $titleHtml = '<a style="margin: 20px 0;" id="' .
            $element->getHtmlId() .
            '-head" href="#' .
            $element->getHtmlId() .
            '-link" onclick="Fieldset.toggleCollapse(\'' .
            $element->getHtmlId() .
            '\', \'' .
            $this->getUrl(
                '*/*/state'
            ) . '\'); return false;"><span style="padding-left:130px;">' .$element->getLegend().'</span>'.$logo . '</a>';

        return $titleHtml;
    }
}