/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

(function (factory) {
	'use strict';

	if (typeof define === 'function' && define.amd) {
		define([
			'jquery',
			'jquery/ui',
			'mage/validation/validation'
		], factory);
	} else {
		factory(jQuery);
	}
}(function ($) {
	'use strict';

	$.widget('mage.validation', $.mage.validation, {
		options: {
			errorPlacement: function (error, element) {
				var errorPlacement = element,
					fieldWrapper, selector;

				// logic for date-picker error placements
				if (element.hasClass('_has-datepicker')) {
					errorPlacement = element.siblings('button');
				}
				// logic for field wrapper
				fieldWrapper = element.closest('.addon');

				if (fieldWrapper.length) {
					errorPlacement = fieldWrapper.after(error);
				}
				//logic for checkboxes/radio
				if (element.is(':checkbox') || element.is(':radio')) {
					errorPlacement = element.parents('.control').children().last();

					//fallback if group does not have .control parent
					if (!errorPlacement.length) {
						errorPlacement = element.siblings('label').last();
					}
				}
				//logic for control with tooltip
				if (element.siblings('.tooltip').length) {
					errorPlacement = element.siblings('.tooltip');
				}

				//logic for bootstrap input-group
				if (element.next().hasClass("input-group-append")) {
					errorPlacement = element.next();
				}

				//logic for swatches list
				selector = element.data("selector");
				 if (selector && selector.search("super-attritube")){
				 	selector = selector.replace(/[^0-9]/g, '');
				 	errorPlacement = element.closest("form").find("div[attribute-id='" + selector + "']");
				 }

				errorPlacement.after(error);
			}
		}
	});

	return $.mage.validation;
}));
